/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.handler.codec.redis;

import io.mantisrx.shaded.io.netty.util.CharsetUtil;
import io.mantisrx.shaded.io.netty.util.internal.PlatformDependent;

final class RedisCodecUtil {
    private RedisCodecUtil() {
    }

    static byte[] longToAsciiBytes(long value) {
        return Long.toString(value).getBytes(CharsetUtil.US_ASCII);
    }

    static short makeShort(char first2, char second) {
        return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)(second << 8 | first2) : (short)(first2 << 8 | second);
    }

    static byte[] shortToBytes(short value) {
        byte[] bytes2 = new byte[2];
        if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
            bytes2[1] = (byte)(value >> 8 & 0xFF);
            bytes2[0] = (byte)(value & 0xFF);
        } else {
            bytes2[0] = (byte)(value >> 8 & 0xFF);
            bytes2[1] = (byte)(value & 0xFF);
        }
        return bytes2;
    }
}

