/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.handler.ssl;

import io.mantisrx.shaded.io.netty.buffer.ByteBufAllocator;
import io.mantisrx.shaded.io.netty.handler.ssl.DefaultOpenSslKeyMaterial;
import io.mantisrx.shaded.io.netty.handler.ssl.OpenSslKeyMaterial;
import io.mantisrx.shaded.io.netty.handler.ssl.OpenSslPrivateKey;
import io.mantisrx.shaded.io.netty.handler.ssl.PemEncoded;
import io.mantisrx.shaded.io.netty.handler.ssl.PemX509Certificate;
import io.mantisrx.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.mantisrx.shaded.io.netty.internal.tcnative.SSL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;

class OpenSslKeyMaterialProvider {
    private final X509KeyManager keyManager;
    private final String password;

    OpenSslKeyMaterialProvider(X509KeyManager keyManager, String password) {
        this.keyManager = keyManager;
        this.password = password;
    }

    X509KeyManager keyManager() {
        return this.keyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator allocator, String alias2) throws Exception {
        X509Certificate[] certificates = this.keyManager.getCertificateChain(alias2);
        if (certificates == null || certificates.length == 0) {
            return null;
        }
        PrivateKey key2 = this.keyManager.getPrivateKey(alias2);
        PemEncoded encoded = PemX509Certificate.toPEM(allocator, true, certificates);
        long chainBio = 0L;
        long pkeyBio = 0L;
        long chain = 0L;
        long pkey = 0L;
        try {
            OpenSslKeyMaterial keyMaterial;
            chainBio = ReferenceCountedOpenSslContext.toBIO(allocator, encoded.retain());
            chain = SSL.parseX509Chain((long)chainBio);
            if (key2 instanceof OpenSslPrivateKey) {
                keyMaterial = ((OpenSslPrivateKey)key2).toKeyMaterial(chain, certificates);
            } else {
                pkeyBio = ReferenceCountedOpenSslContext.toBIO(allocator, key2);
                pkey = key2 == null ? 0L : SSL.parsePrivateKey((long)pkeyBio, (String)this.password);
                keyMaterial = new DefaultOpenSslKeyMaterial(chain, pkey, certificates);
            }
            chain = 0L;
            pkey = 0L;
            OpenSslKeyMaterial openSslKeyMaterial = keyMaterial;
            return openSslKeyMaterial;
        }
        finally {
            SSL.freeBIO((long)chainBio);
            SSL.freeBIO((long)pkeyBio);
            if (chain != 0L) {
                SSL.freeX509Chain((long)chain);
            }
            if (pkey != 0L) {
                SSL.freePrivateKey((long)pkey);
            }
            encoded.release();
        }
    }

    void destroy() {
    }
}

