/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.handler.ssl;

import io.mantisrx.shaded.io.netty.handler.ssl.OpenSslKeyMaterial;
import io.mantisrx.shaded.io.netty.internal.tcnative.SSL;
import io.mantisrx.shaded.io.netty.util.AbstractReferenceCounted;
import io.mantisrx.shaded.io.netty.util.IllegalReferenceCountException;
import io.mantisrx.shaded.io.netty.util.internal.EmptyArrays;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

final class OpenSslPrivateKey
extends AbstractReferenceCounted
implements PrivateKey {
    private long privateKeyAddress;

    OpenSslPrivateKey(long privateKeyAddress) {
        this.privateKeyAddress = privateKeyAddress;
    }

    @Override
    public String getAlgorithm() {
        return "unkown";
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    long privateKeyAddress() {
        if (this.refCnt() <= 0) {
            throw new IllegalReferenceCountException();
        }
        return this.privateKeyAddress;
    }

    @Override
    protected void deallocate() {
        SSL.freePrivateKey((long)this.privateKeyAddress);
        this.privateKeyAddress = 0L;
    }

    @Override
    public OpenSslPrivateKey retain() {
        super.retain();
        return this;
    }

    @Override
    public OpenSslPrivateKey retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public OpenSslPrivateKey touch() {
        super.touch();
        return this;
    }

    @Override
    public OpenSslPrivateKey touch(Object hint) {
        return this;
    }

    @Override
    public void destroy() {
        this.release(this.refCnt());
    }

    @Override
    public boolean isDestroyed() {
        return this.refCnt() == 0;
    }

    OpenSslKeyMaterial toKeyMaterial(long certificateChain, X509Certificate[] chain) {
        return new OpenSslPrivateKeyMaterial(certificateChain, chain);
    }

    private final class OpenSslPrivateKeyMaterial
    implements OpenSslKeyMaterial {
        private long certificateChain;
        private final X509Certificate[] x509CertificateChain;

        OpenSslPrivateKeyMaterial(long certificateChain, X509Certificate[] x509CertificateChain) {
            this.certificateChain = certificateChain;
            this.x509CertificateChain = x509CertificateChain == null ? EmptyArrays.EMPTY_X509_CERTIFICATES : x509CertificateChain;
        }

        @Override
        public X509Certificate[] certificateChain() {
            return (X509Certificate[])this.x509CertificateChain.clone();
        }

        @Override
        public long certificateChainAddress() {
            if (this.refCnt() <= 0) {
                throw new IllegalReferenceCountException();
            }
            return this.certificateChain;
        }

        @Override
        public long privateKeyAddress() {
            return OpenSslPrivateKey.this.privateKeyAddress();
        }

        @Override
        public OpenSslKeyMaterial retain() {
            OpenSslPrivateKey.this.retain();
            return this;
        }

        @Override
        public OpenSslKeyMaterial retain(int increment) {
            OpenSslPrivateKey.this.retain(increment);
            return this;
        }

        @Override
        public OpenSslKeyMaterial touch() {
            OpenSslPrivateKey.this.touch();
            return this;
        }

        @Override
        public OpenSslKeyMaterial touch(Object hint) {
            OpenSslPrivateKey.this.touch(hint);
            return this;
        }

        @Override
        public boolean release() {
            if (OpenSslPrivateKey.this.release()) {
                this.releaseChain();
                return true;
            }
            return false;
        }

        @Override
        public boolean release(int decrement) {
            if (OpenSslPrivateKey.this.release(decrement)) {
                this.releaseChain();
                return true;
            }
            return false;
        }

        private void releaseChain() {
            SSL.freeX509Chain((long)this.certificateChain);
            this.certificateChain = 0L;
        }

        @Override
        public int refCnt() {
            return OpenSslPrivateKey.this.refCnt();
        }
    }
}

