/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.resolver;

import io.mantisrx.shaded.io.netty.resolver.AddressResolver;
import io.mantisrx.shaded.io.netty.util.concurrent.EventExecutor;
import io.mantisrx.shaded.io.netty.util.concurrent.Future;
import io.mantisrx.shaded.io.netty.util.concurrent.Promise;
import io.mantisrx.shaded.io.netty.util.internal.ObjectUtil;
import io.mantisrx.shaded.io.netty.util.internal.TypeParameterMatcher;
import java.net.SocketAddress;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.Collections;
import java.util.List;

public abstract class AbstractAddressResolver<T extends SocketAddress>
implements AddressResolver<T> {
    private final EventExecutor executor;
    private final TypeParameterMatcher matcher;

    protected AbstractAddressResolver(EventExecutor executor) {
        this.executor = ObjectUtil.checkNotNull(executor, "executor");
        this.matcher = TypeParameterMatcher.find(this, AbstractAddressResolver.class, "T");
    }

    protected AbstractAddressResolver(EventExecutor executor, Class<? extends T> addressType) {
        this.executor = ObjectUtil.checkNotNull(executor, "executor");
        this.matcher = TypeParameterMatcher.get(addressType);
    }

    protected EventExecutor executor() {
        return this.executor;
    }

    @Override
    public boolean isSupported(SocketAddress address) {
        return this.matcher.match(address);
    }

    @Override
    public final boolean isResolved(SocketAddress address) {
        if (!this.isSupported(address)) {
            throw new UnsupportedAddressTypeException();
        }
        SocketAddress castAddress = address;
        return this.doIsResolved(castAddress);
    }

    protected abstract boolean doIsResolved(T var1);

    @Override
    public final Future<T> resolve(SocketAddress address) {
        if (!this.isSupported(ObjectUtil.checkNotNull(address, "address"))) {
            return this.executor().newFailedFuture(new UnsupportedAddressTypeException());
        }
        if (this.isResolved(address)) {
            SocketAddress cast2 = address;
            return this.executor.newSucceededFuture(cast2);
        }
        try {
            SocketAddress cast3 = address;
            Promise promise2 = this.executor().newPromise();
            this.doResolve(cast3, promise2);
            return promise2;
        }
        catch (Exception e2) {
            return this.executor().newFailedFuture(e2);
        }
    }

    @Override
    public final Future<T> resolve(SocketAddress address, Promise<T> promise2) {
        ObjectUtil.checkNotNull(address, "address");
        ObjectUtil.checkNotNull(promise2, "promise");
        if (!this.isSupported(address)) {
            return promise2.setFailure(new UnsupportedAddressTypeException());
        }
        if (this.isResolved(address)) {
            SocketAddress cast2 = address;
            return promise2.setSuccess(cast2);
        }
        try {
            SocketAddress cast3 = address;
            this.doResolve(cast3, promise2);
            return promise2;
        }
        catch (Exception e2) {
            return promise2.setFailure(e2);
        }
    }

    @Override
    public final Future<List<T>> resolveAll(SocketAddress address) {
        if (!this.isSupported(ObjectUtil.checkNotNull(address, "address"))) {
            return this.executor().newFailedFuture(new UnsupportedAddressTypeException());
        }
        if (this.isResolved(address)) {
            SocketAddress cast2 = address;
            return this.executor.newSucceededFuture(Collections.singletonList(cast2));
        }
        try {
            SocketAddress cast3 = address;
            Promise<List<T>> promise2 = this.executor().newPromise();
            this.doResolveAll(cast3, promise2);
            return promise2;
        }
        catch (Exception e2) {
            return this.executor().newFailedFuture(e2);
        }
    }

    @Override
    public final Future<List<T>> resolveAll(SocketAddress address, Promise<List<T>> promise2) {
        ObjectUtil.checkNotNull(address, "address");
        ObjectUtil.checkNotNull(promise2, "promise");
        if (!this.isSupported(address)) {
            return promise2.setFailure(new UnsupportedAddressTypeException());
        }
        if (this.isResolved(address)) {
            SocketAddress cast2 = address;
            return promise2.setSuccess(Collections.singletonList(cast2));
        }
        try {
            SocketAddress cast3 = address;
            this.doResolveAll(cast3, promise2);
            return promise2;
        }
        catch (Exception e2) {
            return promise2.setFailure(e2);
        }
    }

    protected abstract void doResolve(T var1, Promise<T> var2) throws Exception;

    protected abstract void doResolveAll(T var1, Promise<List<T>> var2) throws Exception;

    @Override
    public void close() {
    }
}

