/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.resolver.dns;

import io.mantisrx.shaded.io.netty.channel.EventLoop;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsRecord;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsRecordType;
import io.mantisrx.shaded.io.netty.resolver.dns.AuthoritativeDnsServerCache;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsAddressDecoder;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsCache;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsNameResolver;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsResolveContext;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsServerAddressStream;
import io.mantisrx.shaded.io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

final class DnsAddressResolveContext
extends DnsResolveContext<InetAddress> {
    private final DnsCache resolveCache;
    private final AuthoritativeDnsServerCache authoritativeDnsServerCache;

    DnsAddressResolveContext(DnsNameResolver parent, String hostname, DnsRecord[] additionals, DnsServerAddressStream nameServerAddrs, DnsCache resolveCache, AuthoritativeDnsServerCache authoritativeDnsServerCache) {
        super(parent, hostname, 1, parent.resolveRecordTypes(), additionals, nameServerAddrs);
        this.resolveCache = resolveCache;
        this.authoritativeDnsServerCache = authoritativeDnsServerCache;
    }

    @Override
    DnsResolveContext<InetAddress> newResolverContext(DnsNameResolver parent, String hostname, int dnsClass, DnsRecordType[] expectedTypes, DnsRecord[] additionals, DnsServerAddressStream nameServerAddrs) {
        return new DnsAddressResolveContext(parent, hostname, additionals, nameServerAddrs, this.resolveCache, this.authoritativeDnsServerCache);
    }

    @Override
    InetAddress convertRecord(DnsRecord record, String hostname, DnsRecord[] additionals, EventLoop eventLoop) {
        return DnsAddressDecoder.decodeAddress(record, hostname, this.parent.isDecodeIdn());
    }

    @Override
    List<InetAddress> filterResults(List<InetAddress> unfiltered) {
        Class<? extends InetAddress> inetAddressType = this.parent.preferredAddressType().addressType();
        int size = unfiltered.size();
        int numExpected = 0;
        for (int i = 0; i < size; ++i) {
            InetAddress address = unfiltered.get(i);
            if (!inetAddressType.isInstance(address)) continue;
            ++numExpected;
        }
        if (numExpected == size || numExpected == 0) {
            return unfiltered;
        }
        ArrayList<InetAddress> filtered = new ArrayList<InetAddress>(numExpected);
        for (int i = 0; i < size; ++i) {
            InetAddress address = unfiltered.get(i);
            if (!inetAddressType.isInstance(address)) continue;
            filtered.add(address);
        }
        return filtered;
    }

    @Override
    void cache(String hostname, DnsRecord[] additionals, DnsRecord result, InetAddress convertedResult) {
        this.resolveCache.cache(hostname, additionals, convertedResult, result.timeToLive(), this.parent.ch.eventLoop());
    }

    @Override
    void cache(String hostname, DnsRecord[] additionals, UnknownHostException cause) {
        this.resolveCache.cache(hostname, additionals, cause, this.parent.ch.eventLoop());
    }

    @Override
    void doSearchDomainQuery(String hostname, Promise<List<InetAddress>> nextPromise) {
        if (!DnsNameResolver.doResolveAllCached(hostname, this.additionals, nextPromise, this.resolveCache, this.parent.resolvedInternetProtocolFamiliesUnsafe())) {
            super.doSearchDomainQuery(hostname, nextPromise);
        }
    }

    @Override
    DnsCache resolveCache() {
        return this.resolveCache;
    }

    @Override
    AuthoritativeDnsServerCache authoritativeDnsServerCache() {
        return this.authoritativeDnsServerCache;
    }
}

