/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.resolver.dns;

import io.mantisrx.shaded.io.netty.resolver.dns.DefaultDnsServerAddressStreamProvider;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsServerAddressStream;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.mantisrx.shaded.io.netty.resolver.dns.UnixResolverDnsServerAddressStreamProvider;
import io.mantisrx.shaded.io.netty.util.internal.PlatformDependent;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class DnsServerAddressStreamProviders {
    private static final long REFRESH_INTERVAL = TimeUnit.MINUTES.toNanos(5L);
    private static final DnsServerAddressStreamProvider DEFAULT_DNS_SERVER_ADDRESS_STREAM_PROVIDER = new DnsServerAddressStreamProvider(){
        private volatile DnsServerAddressStreamProvider currentProvider = this.provider();
        private final AtomicLong lastRefresh = new AtomicLong(System.nanoTime());

        @Override
        public DnsServerAddressStream nameServerAddressStream(String hostname) {
            long last2 = this.lastRefresh.get();
            DnsServerAddressStreamProvider current = this.currentProvider;
            if (System.nanoTime() - last2 > REFRESH_INTERVAL && this.lastRefresh.compareAndSet(last2, System.nanoTime())) {
                current = this.currentProvider = this.provider();
            }
            return current.nameServerAddressStream(hostname);
        }

        private DnsServerAddressStreamProvider provider() {
            return PlatformDependent.isWindows() ? DefaultDnsServerAddressStreamProvider.INSTANCE : UnixResolverDnsServerAddressStreamProvider.parseSilently();
        }
    };

    private DnsServerAddressStreamProviders() {
    }

    public static DnsServerAddressStreamProvider platformDefault() {
        return DEFAULT_DNS_SERVER_ADDRESS_STREAM_PROVIDER;
    }
}

