/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.util.concurrent;

import io.mantisrx.shaded.io.netty.util.concurrent.Future;
import io.mantisrx.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.mantisrx.shaded.io.netty.util.concurrent.Promise;
import io.mantisrx.shaded.io.netty.util.internal.ObjectUtil;
import io.mantisrx.shaded.io.netty.util.internal.PromiseNotificationUtil;
import io.mantisrx.shaded.io.netty.util.internal.logging.InternalLogger;
import io.mantisrx.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public class PromiseNotifier<V, F extends Future<V>>
implements GenericFutureListener<F> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PromiseNotifier.class);
    private final Promise<? super V>[] promises;
    private final boolean logNotifyFailure;

    @SafeVarargs
    public PromiseNotifier(Promise<? super V> ... promises) {
        this(true, promises);
    }

    @SafeVarargs
    public PromiseNotifier(boolean logNotifyFailure, Promise<? super V> ... promises) {
        ObjectUtil.checkNotNull(promises, "promises");
        for (Promise<? super V> promise2 : promises) {
            if (promise2 != null) continue;
            throw new IllegalArgumentException("promises contains null Promise");
        }
        this.promises = (Promise[])promises.clone();
        this.logNotifyFailure = logNotifyFailure;
    }

    @Override
    public void operationComplete(F future2) throws Exception {
        InternalLogger internalLogger;
        InternalLogger internalLogger2 = internalLogger = this.logNotifyFailure ? logger : null;
        if (future2.isSuccess()) {
            Object result = future2.get();
            for (Promise<? super V> p : this.promises) {
                PromiseNotificationUtil.trySuccess(p, result, internalLogger);
            }
        } else if (future2.isCancelled()) {
            for (Promise<? super V> p : this.promises) {
                PromiseNotificationUtil.tryCancel(p, internalLogger);
            }
        } else {
            Throwable cause = future2.cause();
            for (Promise<? super V> p : this.promises) {
                PromiseNotificationUtil.tryFailure(p, cause, internalLogger);
            }
        }
    }
}

