/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.util.internal;

import java.util.Collection;

public final class ObjectUtil {
    private ObjectUtil() {
    }

    public static <T> T checkNotNull(T arg, String text) {
        if (arg == null) {
            throw new NullPointerException(text);
        }
        return arg;
    }

    public static int checkPositive(int i, String name2) {
        if (i <= 0) {
            throw new IllegalArgumentException(name2 + ": " + i + " (expected: > 0)");
        }
        return i;
    }

    public static long checkPositive(long i, String name2) {
        if (i <= 0L) {
            throw new IllegalArgumentException(name2 + ": " + i + " (expected: > 0)");
        }
        return i;
    }

    public static int checkPositiveOrZero(int i, String name2) {
        if (i < 0) {
            throw new IllegalArgumentException(name2 + ": " + i + " (expected: >= 0)");
        }
        return i;
    }

    public static long checkPositiveOrZero(long i, String name2) {
        if (i < 0L) {
            throw new IllegalArgumentException(name2 + ": " + i + " (expected: >= 0)");
        }
        return i;
    }

    public static <T> T[] checkNonEmpty(T[] array2, String name2) {
        ObjectUtil.checkNotNull(array2, name2);
        ObjectUtil.checkPositive(array2.length, name2 + ".length");
        return array2;
    }

    public static <T extends Collection<?>> T checkNonEmpty(T collection, String name2) {
        ObjectUtil.checkNotNull(collection, name2);
        ObjectUtil.checkPositive(collection.size(), name2 + ".size");
        return collection;
    }

    public static int intValue(Integer wrapper, int defaultValue) {
        return wrapper != null ? wrapper : defaultValue;
    }

    public static long longValue(Long wrapper, long defaultValue) {
        return wrapper != null ? wrapper : defaultValue;
    }
}

