/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize;

import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonParser;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonToken;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JavaType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize.ValueDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class ArrayDeserializer<T>
extends ValueDeserializer<T> {
    private static final long serialVersionUID = 1L;
    private final JavaType valueType;
    private final boolean deserializeNullAsEmptyCollection;

    ArrayDeserializer(JavaType valueType, int typeCount, boolean deserializeNullAsEmptyCollection) {
        super(valueType, typeCount);
        this.valueType = valueType;
        this.deserializeNullAsEmptyCollection = deserializeNullAsEmptyCollection;
    }

    abstract T create(List<Object> var1, DeserializationContext var2) throws JsonMappingException;

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonDeserializer<?> deserializer = this.deserializer(0);
        ArrayList<Object> list = new ArrayList<Object>();
        if (!p.isExpectedStartArrayToken()) {
            throw ArrayDeserializer.mappingException(ctxt, this.valueType.getRawClass(), p.getCurrentToken());
        }
        JsonToken jsonToken = p.nextToken();
        while (jsonToken != JsonToken.END_ARRAY) {
            Object value = jsonToken != JsonToken.VALUE_NULL ? deserializer.deserialize(p, ctxt) : deserializer.getNullValue(ctxt);
            list.add(value);
            jsonToken = p.nextToken();
        }
        return this.create(list, ctxt);
    }

    @Override
    public T getNullValue(DeserializationContext ctxt) throws JsonMappingException {
        if (this.deserializeNullAsEmptyCollection) {
            return this.create(Collections.emptyList(), ctxt);
        }
        return super.getNullValue(ctxt);
    }

    static void checkContainedTypeIsComparable(DeserializationContext ctxt, JavaType type2) throws JsonMappingException {
        Class<?> clz = type2.getRawClass();
        if (clz == Object.class || !Comparable.class.isAssignableFrom(clz)) {
            throw ArrayDeserializer.mappingException(ctxt, clz, null);
        }
    }
}

