/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize;

import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonParser;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonToken;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JavaType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.CollectionType;
import io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize.MaplikeDeserializer;
import io.vavr.Tuple;
import io.vavr.collection.HashMultimap;
import io.vavr.collection.LinkedHashMultimap;
import io.vavr.collection.Multimap;
import io.vavr.collection.TreeMultimap;
import java.io.IOException;
import java.util.ArrayList;

class MultimapDeserializer
extends MaplikeDeserializer<Multimap<?, ?>> {
    private static final long serialVersionUID = 1L;
    private JsonDeserializer<?> containerDeserializer;

    MultimapDeserializer(JavaType valueType) {
        super(valueType);
    }

    @Override
    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        super.resolve(ctxt);
        CollectionType containerType = ctxt.getTypeFactory().constructCollectionType(ArrayList.class, this.javaType.getContentType());
        this.containerDeserializer = ctxt.findContextualValueDeserializer(containerType, null);
    }

    @Override
    public Multimap<?, ?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList result = new ArrayList();
        while (p.nextToken() != JsonToken.END_OBJECT) {
            String name2 = p.getCurrentName();
            Object key2 = this.keyDeserializer.deserializeKey(name2, ctxt);
            p.nextToken();
            ArrayList list = (ArrayList)this.containerDeserializer.deserialize(p, ctxt);
            for (Object elem : list) {
                result.add(Tuple.of(key2, elem));
            }
        }
        if (TreeMultimap.class.isAssignableFrom(this.handledType())) {
            return TreeMultimap.withSeq().ofEntries(this.keyComparator, result);
        }
        if (LinkedHashMultimap.class.isAssignableFrom(this.handledType())) {
            return LinkedHashMultimap.withSeq().ofEntries(result);
        }
        return HashMultimap.withSeq().ofEntries(result);
    }
}

