/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize;

import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonToken;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JavaType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.ArrayList;
import java.util.List;

abstract class ValueDeserializer<T>
extends StdDeserializer<T>
implements ResolvableDeserializer {
    private static final long serialVersionUID = 1L;
    private final JavaType javaType;
    private final int typeCount;
    private final List<JsonDeserializer<?>> deserializers;

    ValueDeserializer(JavaType valueType, int typeCount) {
        super(valueType);
        this.javaType = valueType;
        this.typeCount = typeCount;
        this.deserializers = new ArrayList(typeCount);
    }

    int deserializersCount() {
        return this.deserializers.size();
    }

    JsonDeserializer<?> deserializer(int index2) {
        return this.deserializers.get(index2);
    }

    @Override
    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        if (this.javaType.isCollectionLikeType() || this.javaType.isReferenceType()) {
            this.deserializers.add(ctxt.findRootValueDeserializer(this.javaType.getContentType()));
            return;
        }
        for (int i = 0; i < this.typeCount; ++i) {
            JavaType containedType = this.javaType.containedTypeOrUnknown(i);
            this.deserializers.add(ctxt.findRootValueDeserializer(containedType));
        }
    }

    static JsonMappingException mappingException(DeserializationContext ctxt, Class<?> targetClass, JsonToken token) {
        String tokenDesc = token == null ? "<end of input>" : String.format("%s token", new Object[]{token});
        return JsonMappingException.from(ctxt.getParser(), String.format("Can not deserialize instance of %s out of %s", ValueDeserializer._calcName(targetClass), tokenDesc));
    }

    private static String _calcName(Class<?> cls) {
        if (cls.isArray()) {
            return ValueDeserializer._calcName(cls.getComponentType()) + "[]";
        }
        return cls.getName();
    }
}

