/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.imps;

import io.mantisrx.shaded.org.apache.curator.RetryLoop;
import io.mantisrx.shaded.org.apache.curator.drivers.OperationTrace;
import io.mantisrx.shaded.org.apache.curator.framework.api.BackgroundCallback;
import io.mantisrx.shaded.org.apache.curator.framework.api.BackgroundPathable;
import io.mantisrx.shaded.org.apache.curator.framework.api.BackgroundVersionable;
import io.mantisrx.shaded.org.apache.curator.framework.api.ChildrenDeletable;
import io.mantisrx.shaded.org.apache.curator.framework.api.CuratorEventType;
import io.mantisrx.shaded.org.apache.curator.framework.api.DeleteBuilder;
import io.mantisrx.shaded.org.apache.curator.framework.api.ErrorListenerPathable;
import io.mantisrx.shaded.org.apache.curator.framework.api.Pathable;
import io.mantisrx.shaded.org.apache.curator.framework.api.UnhandledErrorListener;
import io.mantisrx.shaded.org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import io.mantisrx.shaded.org.apache.curator.framework.api.transaction.OperationType;
import io.mantisrx.shaded.org.apache.curator.framework.api.transaction.TransactionDeleteBuilder;
import io.mantisrx.shaded.org.apache.curator.framework.imps.BackgroundOperation;
import io.mantisrx.shaded.org.apache.curator.framework.imps.Backgrounding;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorEventImpl;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorMultiTransactionRecord;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorTransactionImpl;
import io.mantisrx.shaded.org.apache.curator.framework.imps.OperationAndData;
import io.mantisrx.shaded.org.apache.curator.utils.ThreadUtils;
import io.mantisrx.shaded.org.apache.curator.utils.ZKPaths;
import io.mantisrx.shaded.org.apache.zookeeper.AsyncCallback;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.Op;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

class DeleteBuilderImpl
implements DeleteBuilder,
BackgroundOperation<String>,
ErrorListenerPathable<Void> {
    private final CuratorFrameworkImpl client;
    private int version;
    private Backgrounding backgrounding;
    private boolean deletingChildrenIfNeeded;
    private boolean guaranteed;

    DeleteBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.version = -1;
        this.backgrounding = new Backgrounding();
        this.deletingChildrenIfNeeded = false;
        this.guaranteed = false;
    }

    TransactionDeleteBuilder asTransactionDeleteBuilder(final CuratorTransactionImpl curatorTransaction, final CuratorMultiTransactionRecord transaction) {
        return new TransactionDeleteBuilder(){

            @Override
            public CuratorTransactionBridge forPath(String path2) throws Exception {
                String fixedPath = DeleteBuilderImpl.this.client.fixForNamespace(path2);
                transaction.add(Op.delete(fixedPath, DeleteBuilderImpl.this.version), OperationType.DELETE, path2);
                return curatorTransaction;
            }

            @Override
            public Pathable<CuratorTransactionBridge> withVersion(int version) {
                DeleteBuilderImpl.this.withVersion(version);
                return this;
            }
        };
    }

    @Override
    public ChildrenDeletable guaranteed() {
        this.guaranteed = true;
        return this;
    }

    @Override
    public BackgroundVersionable deletingChildrenIfNeeded() {
        this.deletingChildrenIfNeeded = true;
        return this;
    }

    @Override
    public BackgroundPathable<Void> withVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public Pathable<Void> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        try {
            final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("DeleteBuilderImpl-Background");
            this.client.getZooKeeper().delete(operationAndData.getData(), this.version, new AsyncCallback.VoidCallback(){

                @Override
                public void processResult(int rc, String path2, Object ctx) {
                    trace.setReturnCode(rc).setPath(path2).commit();
                    if (rc == KeeperException.Code.NOTEMPTY.intValue() && DeleteBuilderImpl.this.deletingChildrenIfNeeded) {
                        DeleteBuilderImpl.this.backgroundDeleteChildrenThenNode(operationAndData);
                    } else {
                        CuratorEventImpl event = new CuratorEventImpl(DeleteBuilderImpl.this.client, CuratorEventType.DELETE, rc, path2, null, ctx, null, null, null, null, null);
                        DeleteBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
                    }
                }
            }, this.backgrounding.getContext());
        }
        catch (Throwable e2) {
            this.backgrounding.checkError(e2);
        }
    }

    private void backgroundDeleteChildrenThenNode(final OperationAndData<String> mainOperationAndData) {
        BackgroundOperation<String> operation = new BackgroundOperation<String>(){

            @Override
            public void performBackgroundOperation(OperationAndData<String> dummy) throws Exception {
                try {
                    ZKPaths.deleteChildren(DeleteBuilderImpl.this.client.getZooKeeper(), (String)mainOperationAndData.getData(), false);
                }
                catch (KeeperException keeperException) {
                    // empty catch block
                }
                DeleteBuilderImpl.this.client.queueOperation(mainOperationAndData);
            }
        };
        OperationAndData<String> parentOperation = new OperationAndData<String>(operation, mainOperationAndData.getData(), null, null, this.backgrounding.getContext());
        this.client.queueOperation(parentOperation);
    }

    @Override
    public Void forPath(String path2) throws Exception {
        final String unfixedPath = path2;
        path2 = this.client.fixForNamespace(path2);
        if (this.backgrounding.inBackground()) {
            OperationAndData.ErrorCallback<String> errorCallback = null;
            if (this.guaranteed) {
                errorCallback = new OperationAndData.ErrorCallback<String>(){

                    @Override
                    public void retriesExhausted(OperationAndData<String> operationAndData) {
                        DeleteBuilderImpl.this.client.getFailedDeleteManager().addFailedDelete(unfixedPath);
                    }
                };
            }
            this.client.processBackgroundOperation(new OperationAndData<String>(this, path2, this.backgrounding.getCallback(), errorCallback, this.backgrounding.getContext()), null);
        } else {
            this.pathInForeground(path2, unfixedPath);
        }
        return null;
    }

    protected int getVersion() {
        return this.version;
    }

    private void pathInForeground(final String path2, String unfixedPath) throws Exception {
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("DeleteBuilderImpl-Foreground");
        try {
            RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        DeleteBuilderImpl.this.client.getZooKeeper().delete(path2, DeleteBuilderImpl.this.version);
                    }
                    catch (KeeperException.NotEmptyException e2) {
                        if (DeleteBuilderImpl.this.deletingChildrenIfNeeded) {
                            ZKPaths.deleteChildren(DeleteBuilderImpl.this.client.getZooKeeper(), path2, true);
                        }
                        throw e2;
                    }
                    return null;
                }
            });
        }
        catch (Exception e2) {
            ThreadUtils.checkInterrupted(e2);
            if ((RetryLoop.isRetryException(e2) || e2 instanceof InterruptedException) && this.guaranteed) {
                this.client.getFailedDeleteManager().addFailedDelete(unfixedPath);
            }
            throw e2;
        }
        trace.setPath(path2).commit();
    }
}

