/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.recipes.locks;

import io.mantisrx.shaded.com.google.common.base.Predicate;
import io.mantisrx.shaded.org.apache.curator.framework.CuratorFramework;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.locks.InterProcessMutex;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.locks.LockInternalsDriver;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.locks.PredicateResults;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.locks.StandardLockInternalsDriver;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class InterProcessReadWriteLock {
    private final InterProcessMutex readMutex;
    private final InterProcessMutex writeMutex;
    private static final String READ_LOCK_NAME = "__READ__";
    private static final String WRITE_LOCK_NAME = "__WRIT__";

    public InterProcessReadWriteLock(CuratorFramework client, String basePath) {
        this(client, basePath, null);
    }

    public InterProcessReadWriteLock(CuratorFramework client, String basePath, byte[] lockData) {
        lockData = lockData == null ? null : Arrays.copyOf(lockData, lockData.length);
        this.writeMutex = new InternalInterProcessMutex(client, basePath, WRITE_LOCK_NAME, lockData, 1, new SortingLockInternalsDriver(){

            @Override
            public PredicateResults getsTheLock(CuratorFramework client, List<String> children2, String sequenceNodeName, int maxLeases) throws Exception {
                return super.getsTheLock(client, children2, sequenceNodeName, maxLeases);
            }
        });
        this.readMutex = new InternalInterProcessMutex(client, basePath, READ_LOCK_NAME, lockData, Integer.MAX_VALUE, new SortingLockInternalsDriver(){

            @Override
            public PredicateResults getsTheLock(CuratorFramework client, List<String> children2, String sequenceNodeName, int maxLeases) throws Exception {
                return InterProcessReadWriteLock.this.readLockPredicate(children2, sequenceNodeName);
            }
        });
    }

    public InterProcessMutex readLock() {
        return this.readMutex;
    }

    public InterProcessMutex writeLock() {
        return this.writeMutex;
    }

    private PredicateResults readLockPredicate(List<String> children2, String sequenceNodeName) throws Exception {
        if (this.writeMutex.isOwnedByCurrentThread()) {
            return new PredicateResults(null, true);
        }
        int index2 = 0;
        int firstWriteIndex = Integer.MAX_VALUE;
        int ourIndex = -1;
        for (String node2 : children2) {
            if (node2.contains(WRITE_LOCK_NAME)) {
                firstWriteIndex = Math.min(index2, firstWriteIndex);
            } else if (node2.startsWith(sequenceNodeName)) {
                ourIndex = index2;
                break;
            }
            ++index2;
        }
        StandardLockInternalsDriver.validateOurIndex(sequenceNodeName, ourIndex);
        boolean getsTheLock = ourIndex < firstWriteIndex;
        String pathToWatch = getsTheLock ? null : children2.get(firstWriteIndex);
        return new PredicateResults(pathToWatch, getsTheLock);
    }

    private static class InternalInterProcessMutex
    extends InterProcessMutex {
        private final String lockName;
        private final byte[] lockData;

        InternalInterProcessMutex(CuratorFramework client, String path2, String lockName, byte[] lockData, int maxLeases, LockInternalsDriver driver) {
            super(client, path2, lockName, maxLeases, driver);
            this.lockName = lockName;
            this.lockData = lockData;
        }

        @Override
        public Collection<String> getParticipantNodes() throws Exception {
            Collection<String> nodes = super.getParticipantNodes();
            Iterable<String> filtered = Iterables.filter(nodes, new Predicate<String>(){

                @Override
                public boolean apply(String node2) {
                    return node2.contains(InternalInterProcessMutex.this.lockName);
                }
            });
            return ImmutableList.copyOf(filtered);
        }

        @Override
        protected byte[] getLockNodeBytes() {
            return this.lockData;
        }
    }

    private static class SortingLockInternalsDriver
    extends StandardLockInternalsDriver {
        private SortingLockInternalsDriver() {
        }

        @Override
        public final String fixForSorting(String str2, String lockName) {
            str2 = super.fixForSorting(str2, InterProcessReadWriteLock.READ_LOCK_NAME);
            str2 = super.fixForSorting(str2, InterProcessReadWriteLock.WRITE_LOCK_NAME);
            return str2;
        }
    }
}

