/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.utils;

import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.org.apache.curator.utils.CloseableExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class CloseableScheduledExecutorService
extends CloseableExecutorService {
    private final ScheduledExecutorService scheduledExecutorService;

    public CloseableScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        super(scheduledExecutorService, false);
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public CloseableScheduledExecutorService(ScheduledExecutorService scheduledExecutorService, boolean shutdownOnClose) {
        super(scheduledExecutorService, shutdownOnClose);
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public Future<?> schedule(Runnable task, long delay2, TimeUnit unit) {
        Preconditions.checkState(this.isOpen.get(), "CloseableExecutorService is closed");
        CloseableExecutorService.InternalFutureTask<Object> futureTask = new CloseableExecutorService.InternalFutureTask<Object>(new FutureTask<Object>(task, null));
        this.scheduledExecutorService.schedule(futureTask, delay2, unit);
        return futureTask;
    }

    public Future<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay2, TimeUnit unit) {
        Preconditions.checkState(this.isOpen.get(), "CloseableExecutorService is closed");
        ScheduledFuture<?> scheduledFuture = this.scheduledExecutorService.scheduleWithFixedDelay(task, initialDelay, delay2, unit);
        return new CloseableExecutorService.InternalScheduledFutureTask(scheduledFuture);
    }
}

