/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.buffer;

import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffer;
import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBufferFactory;
import io.mantisrx.shaded.org.jboss.netty.buffer.HeapChannelBuffer;
import io.mantisrx.shaded.org.jboss.netty.buffer.HeapChannelBufferFactory;
import java.nio.ByteOrder;

public class LittleEndianHeapChannelBuffer
extends HeapChannelBuffer {
    public LittleEndianHeapChannelBuffer(int length) {
        super(length);
    }

    public LittleEndianHeapChannelBuffer(byte[] array2) {
        super(array2);
    }

    private LittleEndianHeapChannelBuffer(byte[] array2, int readerIndex, int writerIndex) {
        super(array2, readerIndex, writerIndex);
    }

    public ChannelBufferFactory factory() {
        return HeapChannelBufferFactory.getInstance(ByteOrder.LITTLE_ENDIAN);
    }

    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    public short getShort(int index2) {
        return (short)(this.array[index2] & 0xFF | this.array[index2 + 1] << 8);
    }

    public int getUnsignedMedium(int index2) {
        return this.array[index2] & 0xFF | (this.array[index2 + 1] & 0xFF) << 8 | (this.array[index2 + 2] & 0xFF) << 16;
    }

    public int getInt(int index2) {
        return this.array[index2] & 0xFF | (this.array[index2 + 1] & 0xFF) << 8 | (this.array[index2 + 2] & 0xFF) << 16 | (this.array[index2 + 3] & 0xFF) << 24;
    }

    public long getLong(int index2) {
        return (long)this.array[index2] & 0xFFL | ((long)this.array[index2 + 1] & 0xFFL) << 8 | ((long)this.array[index2 + 2] & 0xFFL) << 16 | ((long)this.array[index2 + 3] & 0xFFL) << 24 | ((long)this.array[index2 + 4] & 0xFFL) << 32 | ((long)this.array[index2 + 5] & 0xFFL) << 40 | ((long)this.array[index2 + 6] & 0xFFL) << 48 | ((long)this.array[index2 + 7] & 0xFFL) << 56;
    }

    public void setShort(int index2, int value) {
        this.array[index2] = (byte)value;
        this.array[index2 + 1] = (byte)(value >>> 8);
    }

    public void setMedium(int index2, int value) {
        this.array[index2] = (byte)value;
        this.array[index2 + 1] = (byte)(value >>> 8);
        this.array[index2 + 2] = (byte)(value >>> 16);
    }

    public void setInt(int index2, int value) {
        this.array[index2] = (byte)value;
        this.array[index2 + 1] = (byte)(value >>> 8);
        this.array[index2 + 2] = (byte)(value >>> 16);
        this.array[index2 + 3] = (byte)(value >>> 24);
    }

    public void setLong(int index2, long value) {
        this.array[index2] = (byte)value;
        this.array[index2 + 1] = (byte)(value >>> 8);
        this.array[index2 + 2] = (byte)(value >>> 16);
        this.array[index2 + 3] = (byte)(value >>> 24);
        this.array[index2 + 4] = (byte)(value >>> 32);
        this.array[index2 + 5] = (byte)(value >>> 40);
        this.array[index2 + 6] = (byte)(value >>> 48);
        this.array[index2 + 7] = (byte)(value >>> 56);
    }

    public ChannelBuffer duplicate() {
        return new LittleEndianHeapChannelBuffer(this.array, this.readerIndex(), this.writerIndex());
    }

    public ChannelBuffer copy(int index2, int length) {
        if (index2 < 0 || length < 0 || index2 + length > this.array.length) {
            throw new IndexOutOfBoundsException("Too many bytes to copy - Need " + (index2 + length) + ", maximum is " + this.array.length);
        }
        byte[] copiedArray = new byte[length];
        System.arraycopy(this.array, index2, copiedArray, 0, length);
        return new LittleEndianHeapChannelBuffer(copiedArray);
    }
}

