/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.channel;

import io.mantisrx.shaded.org.jboss.netty.channel.ChannelEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandler;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelPipeline;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelStateEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelUpstreamHandler;
import io.mantisrx.shaded.org.jboss.netty.channel.ChildChannelStateEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.DefaultChannelPipeline;
import io.mantisrx.shaded.org.jboss.netty.channel.ExceptionEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.MessageEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.WriteCompletionEvent;
import io.mantisrx.shaded.org.jboss.netty.logging.InternalLogger;
import io.mantisrx.shaded.org.jboss.netty.logging.InternalLoggerFactory;
import java.util.List;

public class SimpleChannelUpstreamHandler
implements ChannelUpstreamHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SimpleChannelUpstreamHandler.class.getName());

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e2) throws Exception {
        if (e2 instanceof MessageEvent) {
            this.messageReceived(ctx, (MessageEvent)e2);
        } else if (e2 instanceof WriteCompletionEvent) {
            WriteCompletionEvent evt = (WriteCompletionEvent)e2;
            this.writeComplete(ctx, evt);
        } else if (e2 instanceof ChildChannelStateEvent) {
            ChildChannelStateEvent evt = (ChildChannelStateEvent)e2;
            if (evt.getChildChannel().isOpen()) {
                this.childChannelOpen(ctx, evt);
            } else {
                this.childChannelClosed(ctx, evt);
            }
        } else if (e2 instanceof ChannelStateEvent) {
            ChannelStateEvent evt = (ChannelStateEvent)e2;
            switch (evt.getState()) {
                case OPEN: {
                    if (Boolean.TRUE.equals(evt.getValue())) {
                        this.channelOpen(ctx, evt);
                        break;
                    }
                    this.channelClosed(ctx, evt);
                    break;
                }
                case BOUND: {
                    if (evt.getValue() != null) {
                        this.channelBound(ctx, evt);
                        break;
                    }
                    this.channelUnbound(ctx, evt);
                    break;
                }
                case CONNECTED: {
                    if (evt.getValue() != null) {
                        this.channelConnected(ctx, evt);
                        break;
                    }
                    this.channelDisconnected(ctx, evt);
                    break;
                }
                case INTEREST_OPS: {
                    this.channelInterestChanged(ctx, evt);
                    break;
                }
                default: {
                    ctx.sendUpstream(e2);
                    break;
                }
            }
        } else if (e2 instanceof ExceptionEvent) {
            this.exceptionCaught(ctx, (ExceptionEvent)e2);
        } else {
            ctx.sendUpstream(e2);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e2) throws Exception {
        ChannelPipeline pipeline = ctx.getPipeline();
        ChannelHandler last2 = pipeline.getLast();
        if (!(last2 instanceof ChannelUpstreamHandler) && ctx instanceof DefaultChannelPipeline) {
            List<String> names = ctx.getPipeline().getNames();
            for (int i = names.size() - 1; i >= 0; --i) {
                ChannelHandler handler = ctx.getPipeline().get(names.get(i));
                if (!(handler instanceof ChannelUpstreamHandler)) continue;
                last2 = handler;
                break;
            }
        }
        if (this == last2) {
            logger.warn("EXCEPTION, please implement " + this.getClass().getName() + ".exceptionCaught() for proper handling.", e2.getCause());
        }
        ctx.sendUpstream(e2);
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void channelBound(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void channelUnbound(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void childChannelOpen(ChannelHandlerContext ctx, ChildChannelStateEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void childChannelClosed(ChannelHandlerContext ctx, ChildChannelStateEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }
}

