/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.channel.socket.oio;

import io.mantisrx.shaded.org.jboss.netty.channel.Channel;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFuture;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelPipeline;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelState;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelStateEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.Channels;
import io.mantisrx.shaded.org.jboss.netty.channel.MessageEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.oio.AbstractOioChannelSink;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.oio.AbstractOioWorker;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.oio.OioAcceptedSocketChannel;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.oio.OioServerSocketChannel;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.oio.OioSocketChannel;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.oio.OioWorker;
import io.mantisrx.shaded.org.jboss.netty.logging.InternalLogger;
import io.mantisrx.shaded.org.jboss.netty.logging.InternalLoggerFactory;
import io.mantisrx.shaded.org.jboss.netty.util.ThreadNameDeterminer;
import io.mantisrx.shaded.org.jboss.netty.util.ThreadRenamingRunnable;
import io.mantisrx.shaded.org.jboss.netty.util.internal.DeadLockProofWorker;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.concurrent.Executor;

class OioServerSocketPipelineSink
extends AbstractOioChannelSink {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(OioServerSocketPipelineSink.class);
    final Executor workerExecutor;
    private final ThreadNameDeterminer determiner;

    OioServerSocketPipelineSink(Executor workerExecutor, ThreadNameDeterminer determiner) {
        this.workerExecutor = workerExecutor;
        this.determiner = determiner;
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e2) throws Exception {
        Channel channel = e2.getChannel();
        if (channel instanceof OioServerSocketChannel) {
            this.handleServerSocket(e2);
        } else if (channel instanceof OioAcceptedSocketChannel) {
            OioServerSocketPipelineSink.handleAcceptedSocket(e2);
        }
    }

    private void handleServerSocket(ChannelEvent e2) {
        if (!(e2 instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e2;
        OioServerSocketChannel channel = (OioServerSocketChannel)event.getChannel();
        ChannelFuture future2 = event.getFuture();
        ChannelState state = event.getState();
        Object value = event.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value)) break;
                OioServerSocketPipelineSink.close(channel, future2);
                break;
            }
            case BOUND: {
                if (value != null) {
                    this.bind(channel, future2, (SocketAddress)value);
                    break;
                }
                OioServerSocketPipelineSink.close(channel, future2);
            }
        }
    }

    private static void handleAcceptedSocket(ChannelEvent e2) {
        if (e2 instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e2;
            OioAcceptedSocketChannel channel = (OioAcceptedSocketChannel)event.getChannel();
            ChannelFuture future2 = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    AbstractOioWorker.close(channel, future2);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value != null) break;
                    AbstractOioWorker.close(channel, future2);
                    break;
                }
                case INTEREST_OPS: {
                    AbstractOioWorker.setInterestOps(channel, future2, (Integer)value);
                }
            }
        } else if (e2 instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e2;
            OioSocketChannel channel = (OioSocketChannel)event.getChannel();
            ChannelFuture future3 = event.getFuture();
            Object message = event.getMessage();
            OioWorker.write(channel, future3, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void bind(OioServerSocketChannel channel, ChannelFuture future2, SocketAddress localAddress) {
        boolean bound = false;
        boolean bossStarted = false;
        try {
            try {
                channel.socket.bind(localAddress, channel.getConfig().getBacklog());
                bound = true;
                future2.setSuccess();
                localAddress = channel.getLocalAddress();
                Channels.fireChannelBound(channel, localAddress);
                Executor bossExecutor = ((OioServerSocketChannelFactory)channel.getFactory()).bossExecutor;
                DeadLockProofWorker.start(bossExecutor, new ThreadRenamingRunnable(new Boss(channel), "Old I/O server boss (" + channel + ')', this.determiner));
                return;
            }
            catch (Throwable t) {
                future2.setFailure(t);
                Channels.fireExceptionCaught(channel, t);
                Object var8_9 = null;
                if (bossStarted) return;
                if (!bound) return;
                OioServerSocketPipelineSink.close(channel, future2);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (bossStarted || !bound) throw throwable;
            OioServerSocketPipelineSink.close(channel, future2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(OioServerSocketChannel channel, ChannelFuture future2) {
        boolean bound = channel.isBound();
        try {
            channel.socket.close();
            channel.shutdownLock.lock();
            try {
                if (channel.setClosed()) {
                    future2.setSuccess();
                    if (bound) {
                        Channels.fireChannelUnbound(channel);
                    }
                    Channels.fireChannelClosed(channel);
                } else {
                    future2.setSuccess();
                }
                Object var4_3 = null;
                channel.shutdownLock.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                channel.shutdownLock.unlock();
                throw throwable;
            }
        }
        catch (Throwable t) {
            future2.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private final class Boss
    implements Runnable {
        private final OioServerSocketChannel channel;

        Boss(OioServerSocketChannel channel) {
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.channel.shutdownLock.lock();
            try {
                while (this.channel.isBound()) {
                    try {
                        Socket acceptedSocket = this.channel.socket.accept();
                        try {
                            ChannelPipeline pipeline = this.channel.getConfig().getPipelineFactory().getPipeline();
                            OioAcceptedSocketChannel acceptedChannel = new OioAcceptedSocketChannel(this.channel, this.channel.getFactory(), pipeline, OioServerSocketPipelineSink.this, acceptedSocket);
                            DeadLockProofWorker.start(OioServerSocketPipelineSink.this.workerExecutor, new ThreadRenamingRunnable(new OioWorker(acceptedChannel), "Old I/O server worker (parentId: " + this.channel.getId() + ", " + this.channel + ')', OioServerSocketPipelineSink.this.determiner));
                        }
                        catch (Exception e2) {
                            if (logger.isWarnEnabled()) {
                                logger.warn("Failed to initialize an accepted socket.", e2);
                            }
                            try {
                                acceptedSocket.close();
                            }
                            catch (IOException e22) {
                                if (!logger.isWarnEnabled()) continue;
                                logger.warn("Failed to close a partially accepted socket.", e22);
                            }
                        }
                    }
                    catch (SocketTimeoutException e3) {
                    }
                    catch (Throwable e4) {
                        if (!this.channel.socket.isBound() || this.channel.socket.isClosed()) break;
                        if (logger.isWarnEnabled()) {
                            logger.warn("Failed to accept a connection.", e4);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                Object var5_9 = null;
                this.channel.shutdownLock.unlock();
                return;
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                this.channel.shutdownLock.unlock();
                throw throwable;
            }
        }
    }
}

