/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx;

import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffer;
import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffers;
import io.mantisrx.shaded.org.jboss.netty.channel.Channel;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFuture;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFutureListener;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandler;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelPipeline;
import io.mantisrx.shaded.org.jboss.netty.channel.DefaultChannelFuture;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpMethod;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpResponse;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpVersion;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocket00FrameDecoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketClientHandshaker00
extends WebSocketClientHandshaker {
    private ChannelBuffer expectedChallengeResponseBytes;

    public WebSocketClientHandshaker00(URI webSocketURL, WebSocketVersion version, String subprotocol, Map<String, String> customHeaders) {
        this(webSocketURL, version, subprotocol, customHeaders, Long.MAX_VALUE);
    }

    public WebSocketClientHandshaker00(URI webSocketURL, WebSocketVersion version, String subprotocol, Map<String, String> customHeaders, long maxFramePayloadLength) {
        super(webSocketURL, version, subprotocol, customHeaders, maxFramePayloadLength);
    }

    @Override
    public ChannelFuture handshake(Channel channel) {
        int spaces1 = WebSocketUtil.randomNumber(1, 12);
        int spaces2 = WebSocketUtil.randomNumber(1, 12);
        int max1 = Integer.MAX_VALUE / spaces1;
        int max2 = Integer.MAX_VALUE / spaces2;
        int number1 = WebSocketUtil.randomNumber(0, max1);
        int number2 = WebSocketUtil.randomNumber(0, max2);
        int product1 = number1 * spaces1;
        int product2 = number2 * spaces2;
        String key1 = Integer.toString(product1);
        String key2 = Integer.toString(product2);
        key1 = WebSocketClientHandshaker00.insertRandomCharacters(key1);
        key2 = WebSocketClientHandshaker00.insertRandomCharacters(key2);
        key1 = WebSocketClientHandshaker00.insertSpaces(key1, spaces1);
        key2 = WebSocketClientHandshaker00.insertSpaces(key2, spaces2);
        byte[] key3 = WebSocketUtil.randomBytes(8);
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(number1);
        byte[] number1Array = buffer.array();
        buffer = ByteBuffer.allocate(4);
        buffer.putInt(number2);
        byte[] number2Array = buffer.array();
        byte[] challenge = new byte[16];
        System.arraycopy(number1Array, 0, challenge, 0, 4);
        System.arraycopy(number2Array, 0, challenge, 4, 4);
        System.arraycopy(key3, 0, challenge, 8, 8);
        this.expectedChallengeResponseBytes = WebSocketUtil.md5(ChannelBuffers.wrappedBuffer(challenge));
        URI wsURL = this.getWebSocketUrl();
        String path2 = wsURL.getPath();
        if (wsURL.getQuery() != null && wsURL.getQuery().length() > 0) {
            path2 = wsURL.getPath() + '?' + wsURL.getQuery();
        }
        if (path2 == null || path2.length() == 0) {
            path2 = "/";
        }
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, path2);
        request.addHeader("Upgrade", "WebSocket");
        request.addHeader("Connection", "Upgrade");
        request.addHeader("Host", wsURL.getHost());
        int wsPort = wsURL.getPort();
        String originValue = "http://" + wsURL.getHost();
        if (wsPort != 80 && wsPort != 443) {
            originValue = originValue + ':' + wsPort;
        }
        request.addHeader("Origin", originValue);
        request.addHeader("Sec-WebSocket-Key1", key1);
        request.addHeader("Sec-WebSocket-Key2", key2);
        String expectedSubprotocol = this.getExpectedSubprotocol();
        if (expectedSubprotocol != null && expectedSubprotocol.length() != 0) {
            request.addHeader("Sec-WebSocket-Protocol", expectedSubprotocol);
        }
        if (this.customHeaders != null) {
            for (Map.Entry e2 : this.customHeaders.entrySet()) {
                request.addHeader((String)e2.getKey(), e2.getValue());
            }
        }
        request.setHeader("Content-Length", key3.length);
        request.setContent(ChannelBuffers.copiedBuffer(key3));
        final DefaultChannelFuture handshakeFuture = new DefaultChannelFuture(channel, false);
        ChannelFuture future2 = channel.write(request);
        future2.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future2) {
                ChannelPipeline p = future2.getChannel().getPipeline();
                p.replace(HttpRequestEncoder.class, "ws-encoder", (ChannelHandler)new WebSocket00FrameEncoder());
                if (future2.isSuccess()) {
                    handshakeFuture.setSuccess();
                } else {
                    handshakeFuture.setFailure(future2.getCause());
                }
            }
        });
        return handshakeFuture;
    }

    @Override
    public void finishHandshake(Channel channel, HttpResponse response) {
        HttpResponseStatus status = new HttpResponseStatus(101, "WebSocket Protocol Handshake");
        if (!response.getStatus().equals(status)) {
            throw new WebSocketHandshakeException("Invalid handshake response status: " + response.getStatus());
        }
        String upgrade = response.getHeader("Upgrade");
        if (!"WebSocket".equals(upgrade)) {
            throw new WebSocketHandshakeException("Invalid handshake response upgrade: " + upgrade);
        }
        String connection = response.getHeader("Connection");
        if (!"Upgrade".equals(connection)) {
            throw new WebSocketHandshakeException("Invalid handshake response connection: " + connection);
        }
        ChannelBuffer challenge = response.getContent();
        if (!challenge.equals(this.expectedChallengeResponseBytes)) {
            throw new WebSocketHandshakeException("Invalid challenge");
        }
        String subprotocol = response.getHeader("Sec-WebSocket-Protocol");
        this.setActualSubprotocol(subprotocol);
        this.setHandshakeComplete();
        channel.getPipeline().get(HttpResponseDecoder.class).replace("ws-decoder", new WebSocket00FrameDecoder(this.getMaxFramePayloadLength()));
    }

    private static String insertRandomCharacters(String key2) {
        int count2 = WebSocketUtil.randomNumber(1, 12);
        char[] randomChars = new char[count2];
        int randCount = 0;
        while (randCount < count2) {
            int rand2 = (int)(Math.random() * 126.0 + 33.0);
            if ((33 >= rand2 || rand2 >= 47) && (58 >= rand2 || rand2 >= 126)) continue;
            randomChars[randCount] = (char)rand2;
            ++randCount;
        }
        for (int i = 0; i < count2; ++i) {
            int split2 = WebSocketUtil.randomNumber(0, key2.length());
            String part1 = key2.substring(0, split2);
            String part2 = key2.substring(split2);
            key2 = part1 + randomChars[i] + part2;
        }
        return key2;
    }

    private static String insertSpaces(String key2, int spaces) {
        for (int i = 0; i < spaces; ++i) {
            int split2 = WebSocketUtil.randomNumber(1, key2.length() - 1);
            String part1 = key2.substring(0, split2);
            String part2 = key2.substring(split2);
            key2 = part1 + ' ' + part2;
        }
        return key2;
    }
}

