/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx;

import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffer;
import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffers;
import io.mantisrx.shaded.org.jboss.netty.channel.Channel;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFuture;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFutureListener;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandler;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelPipeline;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpRequest;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpVersion;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocket07FrameDecoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocket07FrameEncoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.mantisrx.shaded.org.jboss.netty.logging.InternalLogger;
import io.mantisrx.shaded.org.jboss.netty.logging.InternalLoggerFactory;
import io.mantisrx.shaded.org.jboss.netty.util.CharsetUtil;

public class WebSocketServerHandshaker07
extends WebSocketServerHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketServerHandshaker07.class);
    public static final String WEBSOCKET_07_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private final boolean allowExtensions;

    public WebSocketServerHandshaker07(String webSocketURL, String subprotocols, boolean allowExtensions, long maxFramePayloadLength) {
        super(WebSocketVersion.V07, webSocketURL, subprotocols, maxFramePayloadLength);
        this.allowExtensions = allowExtensions;
    }

    public ChannelFuture handshake(Channel channel, HttpRequest req) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Channel %s WS Version 7 server handshake", channel.getId()));
        }
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        String key2 = req.getHeader("Sec-WebSocket-Key");
        if (key2 == null) {
            throw new WebSocketHandshakeException("not a WebSocket request: missing key");
        }
        String acceptSeed = key2 + WEBSOCKET_07_ACCEPT_GUID;
        ChannelBuffer sha1 = WebSocketUtil.sha1(ChannelBuffers.copiedBuffer((CharSequence)acceptSeed, CharsetUtil.US_ASCII));
        String accept = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("WS Version 7 Server Handshake key: %s. Response: %s.", key2, accept));
        }
        res.setStatus(HttpResponseStatus.SWITCHING_PROTOCOLS);
        res.addHeader("Upgrade", "WebSocket".toLowerCase());
        res.addHeader("Connection", "Upgrade");
        res.addHeader("Sec-WebSocket-Accept", accept);
        String subprotocols = req.getHeader("Sec-WebSocket-Protocol");
        if (subprotocols != null) {
            String selectedSubprotocol = this.selectSubprotocol(subprotocols);
            if (selectedSubprotocol == null) {
                throw new WebSocketHandshakeException("Requested subprotocol(s) not supported: " + subprotocols);
            }
            res.addHeader("Sec-WebSocket-Protocol", selectedSubprotocol);
            this.setSelectedSubprotocol(selectedSubprotocol);
        }
        ChannelFuture future2 = channel.write(res);
        future2.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future2) {
                ChannelPipeline p = future2.getChannel().getPipeline();
                if (p.get(HttpChunkAggregator.class) != null) {
                    p.remove(HttpChunkAggregator.class);
                }
                p.get(HttpRequestDecoder.class).replace("wsdecoder", new WebSocket07FrameDecoder(true, WebSocketServerHandshaker07.this.allowExtensions, WebSocketServerHandshaker07.this.getMaxFramePayloadLength()));
                p.replace(HttpResponseEncoder.class, "wsencoder", (ChannelHandler)new WebSocket07FrameEncoder(false));
            }
        });
        return future2;
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame frame) {
        ChannelFuture future2 = channel.write(frame);
        future2.addListener(ChannelFutureListener.CLOSE);
        return future2;
    }
}

