/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.util.internal;

import io.mantisrx.shaded.org.jboss.netty.logging.InternalLogger;
import io.mantisrx.shaded.org.jboss.netty.logging.InternalLoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public final class SystemPropertyUtil {
    private static boolean initializedLogger;
    private static final InternalLogger logger;
    private static boolean loggedException;
    private static final Pattern INTEGER_PATTERN;

    public static boolean contains(String key2) {
        return SystemPropertyUtil.get(key2) != null;
    }

    public static String get(String key2) {
        return SystemPropertyUtil.get(key2, null);
    }

    public static String get(String key2, String def) {
        String value;
        block5: {
            if (key2 == null) {
                throw new NullPointerException("key");
            }
            if (key2.length() == 0) {
                throw new IllegalArgumentException("key must not be empty.");
            }
            value = null;
            try {
                value = System.getProperty(key2);
            }
            catch (Exception e2) {
                if (loggedException) break block5;
                SystemPropertyUtil.log("Unable to retrieve a system property '" + key2 + "'; default values will be used.", e2);
                loggedException = true;
            }
        }
        if (value == null) {
            return def;
        }
        return value;
    }

    public static boolean getBoolean(String key2, boolean def) {
        String value = SystemPropertyUtil.get(key2);
        if (value == null) {
            return def;
        }
        if ((value = value.trim().toLowerCase()).length() == 0) {
            return true;
        }
        if ("true".equals(value) || "yes".equals(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "no".equals(value) || "0".equals(value)) {
            return false;
        }
        SystemPropertyUtil.log("Unable to parse the boolean system property '" + key2 + "':" + value + " - " + "using the default value: " + def);
        return def;
    }

    public static int getInt(String key2, int def) {
        String value = SystemPropertyUtil.get(key2);
        if (value == null) {
            return def;
        }
        if (INTEGER_PATTERN.matcher(value = value.trim().toLowerCase()).matches()) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SystemPropertyUtil.log("Unable to parse the integer system property '" + key2 + "':" + value + " - " + "using the default value: " + def);
        return def;
    }

    public static long getLong(String key2, long def) {
        String value = SystemPropertyUtil.get(key2);
        if (value == null) {
            return def;
        }
        if (INTEGER_PATTERN.matcher(value = value.trim().toLowerCase()).matches()) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        SystemPropertyUtil.log("Unable to parse the long integer system property '" + key2 + "':" + value + " - " + "using the default value: " + def);
        return def;
    }

    private static void log(String msg) {
        if (initializedLogger) {
            logger.warn(msg);
        } else {
            Logger.getLogger(SystemPropertyUtil.class.getName()).log(Level.WARNING, msg);
        }
    }

    private static void log(String msg, Exception e2) {
        if (initializedLogger) {
            logger.warn(msg, e2);
        } else {
            Logger.getLogger(SystemPropertyUtil.class.getName()).log(Level.WARNING, msg, e2);
        }
    }

    private SystemPropertyUtil() {
    }

    static {
        logger = InternalLoggerFactory.getInstance(SystemPropertyUtil.class);
        initializedLogger = true;
        INTEGER_PATTERN = Pattern.compile("-?[0-9]+");
    }
}

