/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import io.vavr.collection.Stream;
import io.vavr.collection.Traversable;
import io.vavr.collection.Tree;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

interface TreeModule {
    public static <T, U> Tree<U> flatMap(Tree.Node<T> node2, Function<? super T, ? extends Iterable<? extends U>> mapper) {
        Tree<U> mapped = Tree.ofAll(mapper.apply(node2.getValue()));
        if (mapped.isEmpty()) {
            return Tree.empty();
        }
        List children2 = (List)node2.getChildren().map(child -> TreeModule.flatMap(child, mapper)).filter(Traversable::nonEmpty);
        return Tree.of(mapped.get(), children2.prependAll(mapped.getChildren()));
    }

    public static <T, U> Tree.Node<U> map(Tree.Node<T> node2, Function<? super T, ? extends U> mapper) {
        U value = mapper.apply(node2.getValue());
        LinearSeq children2 = node2.getChildren().map(child -> TreeModule.map(child, mapper));
        return new Tree.Node<U>(value, children2);
    }

    public static <T> Tree.Node<T> replace(Tree.Node<T> node2, T currentElement, T newElement) {
        if (Objects.equals(node2.getValue(), currentElement)) {
            return new Tree.Node<T>(newElement, node2.getChildren());
        }
        for (Tree.Node node3 : node2.getChildren()) {
            Tree.Node<T> newChild = TreeModule.replace(node3, currentElement, newElement);
            boolean found = newChild != node3;
            if (!found) continue;
            LinearSeq newChildren = node2.getChildren().replace((Object)node3, newChild);
            return new Tree.Node<T>(node2.getValue(), newChildren);
        }
        return node2;
    }

    public static <T> Stream<Tree.Node<T>> traversePreOrder(Tree.Node<T> node2) {
        return node2.getChildren().foldLeft(Stream.of(node2), (acc, child) -> acc.appendAll((Iterable)TreeModule.traversePreOrder(child)));
    }

    public static <T> Stream<Tree.Node<T>> traverseInOrder(Tree.Node<T> node2) {
        if (node2.isLeaf()) {
            return Stream.of(node2);
        }
        List<Tree.Node<T>> children2 = node2.getChildren();
        return children2.tail().foldLeft(Stream.empty(), (acc, child) -> acc.appendAll((Iterable)TreeModule.traverseInOrder(child))).prepend(node2).prependAll(TreeModule.traverseInOrder((Tree.Node)children2.head()));
    }

    public static <T> Stream<Tree.Node<T>> traversePostOrder(Tree.Node<T> node2) {
        return node2.getChildren().foldLeft(Stream.empty(), (acc, child) -> acc.appendAll((Iterable)TreeModule.traversePostOrder(child))).append(node2);
    }

    public static <T> Stream<Tree.Node<T>> traverseLevelOrder(Tree.Node<T> node2) {
        LinearSeq result = Stream.empty();
        LinkedList<Tree.Node<T>> queue = new LinkedList<Tree.Node<T>>();
        queue.add(node2);
        while (!queue.isEmpty()) {
            Tree.Node next2 = (Tree.Node)queue.remove();
            result = result.prepend(next2);
            queue.addAll(next2.getChildren().toJavaList());
        }
        return result.reverse();
    }

    public static <T, T1, T2> Tuple2<Tree.Node<T1>, Tree.Node<T2>> unzip(Tree.Node<T> node2, Function<? super T, Tuple2<? extends T1, ? extends T2>> unzipper) {
        Tuple2<? extends T1, ? extends T2> value = unzipper.apply(node2.getValue());
        LinearSeq children2 = node2.getChildren().map(child -> TreeModule.unzip(child, unzipper));
        Tree.Node node1 = new Tree.Node(value._1, children2.map(t -> (Tree.Node)t._1));
        Tree.Node node22 = new Tree.Node(value._2, children2.map(t -> (Tree.Node)t._2));
        return Tuple.of(node1, node22);
    }

    public static <T, T1, T2, T3> Tuple3<Tree.Node<T1>, Tree.Node<T2>, Tree.Node<T3>> unzip3(Tree.Node<T> node2, Function<? super T, Tuple3<? extends T1, ? extends T2, ? extends T3>> unzipper) {
        Tuple3<? extends T1, ? extends T2, ? extends T3> value = unzipper.apply(node2.getValue());
        LinearSeq children2 = node2.getChildren().map(child -> TreeModule.unzip3(child, unzipper));
        Tree.Node node1 = new Tree.Node(value._1, children2.map(t -> (Tree.Node)t._1));
        Tree.Node node22 = new Tree.Node(value._2, children2.map(t -> (Tree.Node)t._2));
        Tree.Node node3 = new Tree.Node(value._3, children2.map(t -> (Tree.Node)t._3));
        return Tuple.of(node1, node22, node3);
    }

    public static <T, U, R> Tree<R> zip(Tree.Node<T> node2, Iterator<? extends U> that, BiFunction<? super T, ? super U, ? extends R> mapper) {
        if (!that.hasNext()) {
            return Tree.Empty.instance();
        }
        R value = mapper.apply(node2.getValue(), that.next());
        List children2 = (List)node2.getChildren().map(child -> TreeModule.zip(child, that, mapper)).filter(Traversable::nonEmpty);
        return new Tree.Node<R>(value, children2);
    }

    public static <T, U> Tree<Tuple2<T, U>> zipAll(Tree.Node<T> node2, Iterator<? extends U> that, U thatElem) {
        if (!that.hasNext()) {
            return node2.map(value -> Tuple.of(value, thatElem));
        }
        Tuple2<T, U> value2 = Tuple.of(node2.getValue(), that.next());
        List children2 = (List)node2.getChildren().map(child -> TreeModule.zipAll(child, that, thatElem)).filter(Traversable::nonEmpty);
        return new Tree.Node<Tuple2<T, U>>(value2, children2);
    }
}

