/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.plugins.RxJavaHooks;

public final class OnSubscribeLift<T, R>
implements Observable.OnSubscribe<R> {
    final Observable.OnSubscribe<T> parent;
    final Observable.Operator<? extends R, ? super T> operator;

    public OnSubscribeLift(Observable.OnSubscribe<T> parent, Observable.Operator<? extends R, ? super T> operator) {
        this.parent = parent;
        this.operator = operator;
    }

    @Override
    public void call(Subscriber<? super R> o) {
        try {
            Subscriber st = (Subscriber)RxJavaHooks.onObservableLift(this.operator).call(o);
            try {
                st.onStart();
                this.parent.call(st);
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                st.onError(e2);
            }
        }
        catch (Throwable e3) {
            Exceptions.throwIfFatal(e3);
            o.onError(e3);
        }
    }
}

