/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayDeque;
import java.util.Deque;
import rx.Observable;
import rx.Subscriber;
import rx.internal.operators.NotificationLite;

public class OperatorSkipLast<T>
implements Observable.Operator<T, T> {
    final int count;

    public OperatorSkipLast(int count2) {
        if (count2 < 0) {
            throw new IndexOutOfBoundsException("count could not be negative");
        }
        this.count = count2;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> subscriber2) {
        return new Subscriber<T>(subscriber2){
            private final Deque<Object> deque;
            {
                super(subscriber22);
                this.deque = new ArrayDeque<Object>();
            }

            @Override
            public void onCompleted() {
                subscriber2.onCompleted();
            }

            @Override
            public void onError(Throwable e2) {
                subscriber2.onError(e2);
            }

            @Override
            public void onNext(T value) {
                if (OperatorSkipLast.this.count == 0) {
                    subscriber2.onNext(value);
                    return;
                }
                if (this.deque.size() == OperatorSkipLast.this.count) {
                    subscriber2.onNext(NotificationLite.getValue(this.deque.removeFirst()));
                } else {
                    this.request(1L);
                }
                this.deque.offerLast(NotificationLite.next(value));
            }
        };
    }
}

