/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.functions.Func1;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;

public final class OperatorTakeLast<T>
implements Observable.Operator<T, T> {
    final int count;

    public OperatorTakeLast(int count2) {
        if (count2 < 0) {
            throw new IndexOutOfBoundsException("count cannot be negative");
        }
        this.count = count2;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> subscriber2) {
        final TakeLastSubscriber<? super T> parent = new TakeLastSubscriber<T>(subscriber2, this.count);
        subscriber2.add(parent);
        subscriber2.setProducer(new Producer(){

            @Override
            public void request(long n) {
                parent.requestMore(n);
            }
        });
        return parent;
    }

    static final class TakeLastSubscriber<T>
    extends Subscriber<T>
    implements Func1<Object, T> {
        final Subscriber<? super T> actual;
        final AtomicLong requested;
        final ArrayDeque<Object> queue;
        final int count;

        public TakeLastSubscriber(Subscriber<? super T> actual, int count2) {
            this.actual = actual;
            this.count = count2;
            this.requested = new AtomicLong();
            this.queue = new ArrayDeque();
        }

        @Override
        public void onNext(T t) {
            if (this.queue.size() == this.count) {
                this.queue.poll();
            }
            this.queue.offer(NotificationLite.next(t));
        }

        @Override
        public void onError(Throwable e2) {
            this.queue.clear();
            this.actual.onError(e2);
        }

        @Override
        public void onCompleted() {
            BackpressureUtils.postCompleteDone(this.requested, this.queue, this.actual, this);
        }

        @Override
        public T call(Object t) {
            return NotificationLite.getValue(t);
        }

        void requestMore(long n) {
            if (n > 0L) {
                BackpressureUtils.postCompleteRequest(this.requested, n, this.queue, this.actual, this);
            }
        }
    }
}

