/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.schedulers;

import rx.Scheduler;
import rx.exceptions.Exceptions;
import rx.functions.Action0;

class SleepingAction
implements Action0 {
    private final Action0 underlying;
    private final Scheduler.Worker innerScheduler;
    private final long execTime;

    public SleepingAction(Action0 underlying, Scheduler.Worker scheduler, long execTime) {
        this.underlying = underlying;
        this.innerScheduler = scheduler;
        this.execTime = execTime;
    }

    @Override
    public void call() {
        if (this.innerScheduler.isUnsubscribed()) {
            return;
        }
        long delay2 = this.execTime - this.innerScheduler.now();
        if (delay2 > 0L) {
            try {
                Thread.sleep(delay2);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                Exceptions.propagate(e2);
            }
        }
        if (this.innerScheduler.isUnsubscribed()) {
            return;
        }
        this.underlying.call();
    }
}

