/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.config.AbstractConfig;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class PrivateViewConfig
extends AbstractConfig {
    private volatile State state;

    public PrivateViewConfig(Config wrappedConfig) {
        this.state = new State(wrappedConfig);
        wrappedConfig.addListener(new ViewConfigListener(this));
    }

    @Override
    public Iterator<String> getKeys() {
        return this.state.data.keySet().iterator();
    }

    @Override
    public boolean containsKey(String key2) {
        return this.state.data.containsKey(key2);
    }

    @Override
    public boolean isEmpty() {
        return this.state.data.isEmpty();
    }

    @Override
    public <T> T accept(Config.Visitor<T> visitor) {
        T t = null;
        for (Map.Entry<String, Object> entry : this.state.data.entrySet()) {
            t = visitor.visitKey(entry.getKey(), entry.getValue());
        }
        return t;
    }

    @Override
    public Object getRawProperty(String key2) {
        return this.state.data.get(key2);
    }

    private static class ViewConfigListener
    implements ConfigListener {
        private final Reference<PrivateViewConfig> vcRef;

        private ViewConfigListener(PrivateViewConfig pvc) {
            this.vcRef = new WeakReference<PrivateViewConfig>(pvc);
        }

        @Override
        public void onConfigAdded(Config config) {
            this.updateState(config).ifPresent(vc -> vc.notifyConfigAdded((Config)vc));
        }

        @Override
        public void onConfigRemoved(Config config) {
            this.updateState(config).ifPresent(vc -> vc.notifyConfigRemoved((Config)vc));
        }

        @Override
        public void onConfigUpdated(Config config) {
            this.updateState(config).ifPresent(vc -> vc.notifyConfigUpdated((Config)vc));
        }

        @Override
        public void onError(Throwable error, Config config) {
        }

        private Optional<PrivateViewConfig> updateState(Config updatedWrappedConfig) {
            PrivateViewConfig pvc = this.vcRef.get();
            if (pvc != null) {
                pvc.state = new State(updatedWrappedConfig);
                return Optional.of(pvc);
            }
            updatedWrappedConfig.removeListener(this);
            return Optional.empty();
        }
    }

    private static class State {
        final Map<String, Object> data = new LinkedHashMap<String, Object>();

        public State(Config config) {
            config.forEachProperty(this.data::put);
        }
    }
}

