/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.netty.pipeline;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import io.mantisrx.publish.internal.metrics.SpectatorUtils;
import io.mantisrx.shaded.io.netty.buffer.ByteBuf;
import io.mantisrx.shaded.io.netty.buffer.ByteBufOutputStream;
import io.mantisrx.shaded.io.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.io.netty.handler.codec.MessageToMessageEncoder;
import io.mantisrx.shaded.io.netty.handler.codec.http.FullHttpRequest;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;

class GzipEncoder
extends MessageToMessageEncoder<FullHttpRequest> {
    private final Registry registry;
    private final Timer encodeTime;

    GzipEncoder(Registry registry) {
        this.registry = registry;
        this.encodeTime = SpectatorUtils.buildAndRegisterTimer(registry, "encodeTime", "channel", "netty", "encoder", "gzip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, FullHttpRequest msg, List<Object> out) {
        long start = this.registry.clock().wallTime();
        ByteBuf buf = ctx.alloc().directBuffer();
        try (ByteBufOutputStream bbos = new ByteBufOutputStream(buf);
             GZIPOutputStream gos = new GZIPOutputStream(bbos);){
            msg.content().readBytes(gos, msg.content().readableBytes());
            gos.finish();
            FullHttpRequest message = msg.replace(buf.retain());
            out.add(message);
        }
        catch (Exception e2) {
            ctx.fireExceptionCaught(new IOException("error encoding message", e2));
        }
        finally {
            buf.release();
        }
        long end = this.registry.clock().wallTime();
        this.encodeTime.record(end - start, TimeUnit.MILLISECONDS);
    }
}

