/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.netty.pipeline;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import io.mantisrx.publish.internal.exceptions.NonRetryableException;
import io.mantisrx.publish.internal.exceptions.RetryableException;
import io.mantisrx.publish.internal.metrics.SpectatorUtils;
import io.mantisrx.shaded.io.netty.channel.ChannelHandler;
import io.mantisrx.shaded.io.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.io.netty.channel.SimpleChannelInboundHandler;
import io.mantisrx.shaded.io.netty.handler.codec.http.FullHttpResponse;
import io.mantisrx.shaded.io.netty.handler.codec.http.HttpStatusClass;
import io.mantisrx.shaded.io.netty.handler.timeout.IdleStateEvent;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
class HttpEventChannelHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpEventChannelHandler.class);
    private final Counter droppedBatches;

    HttpEventChannelHandler(Registry registry) {
        this.droppedBatches = SpectatorUtils.buildAndRegisterCounter(registry, "droppedBatches", "channel", "netty");
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) {
        HttpStatusClass status = msg.status().codeClass();
        if (status != HttpStatusClass.SUCCESS) {
            this.droppedBatches.increment();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("got http response. status: {}, headers: {}, message: {}", msg.status().codeAsText(), msg.headers().entries().toString(), msg.content().toString(StandardCharsets.UTF_8));
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent) {
            LOG.warn("closing idle channel");
            ctx.channel().close();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.debug("caught exception from handler", cause);
        this.droppedBatches.increment();
        if (!(cause instanceof RetryableException) && !(cause instanceof NonRetryableException)) {
            ctx.channel().close();
        }
    }
}

