/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server;

import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.common.Time;
import io.mantisrx.shaded.org.apache.zookeeper.server.SessionTracker;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperCriticalThread;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperServerListener;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooTrace;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTrackerImpl
extends ZooKeeperCriticalThread
implements SessionTracker {
    private static final Logger LOG = LoggerFactory.getLogger(SessionTrackerImpl.class);
    HashMap<Long, SessionImpl> sessionsById = new HashMap();
    HashMap<Long, SessionSet> sessionSets = new HashMap();
    ConcurrentHashMap<Long, Integer> sessionsWithTimeout;
    long nextSessionId = 0L;
    long nextExpirationTime;
    int expirationInterval;
    SessionTracker.SessionExpirer expirer;
    volatile boolean running = true;
    volatile long currentTime;

    public static long initializeNextSession(long id) {
        long nextSid = 0L;
        nextSid = Time.currentElapsedTime() << 24 >>> 8;
        return nextSid |= id << 56;
    }

    private long roundToInterval(long time2) {
        return (time2 / (long)this.expirationInterval + 1L) * (long)this.expirationInterval;
    }

    public SessionTrackerImpl(SessionTracker.SessionExpirer expirer, ConcurrentHashMap<Long, Integer> sessionsWithTimeout, int tickTime, long sid, ZooKeeperServerListener listener) {
        super("SessionTracker", listener);
        this.expirer = expirer;
        this.expirationInterval = tickTime;
        this.sessionsWithTimeout = sessionsWithTimeout;
        this.nextExpirationTime = this.roundToInterval(Time.currentElapsedTime());
        this.nextSessionId = SessionTrackerImpl.initializeNextSession(sid);
        for (Map.Entry<Long, Integer> e2 : sessionsWithTimeout.entrySet()) {
            this.addSession(e2.getKey(), e2.getValue());
        }
    }

    @Override
    public synchronized void dumpSessions(PrintWriter pwriter) {
        pwriter.print("Session Sets (");
        pwriter.print(this.sessionSets.size());
        pwriter.println("):");
        ArrayList<Long> keys2 = new ArrayList<Long>(this.sessionSets.keySet());
        Collections.sort(keys2);
        for (long time2 : keys2) {
            pwriter.print(this.sessionSets.get((Object)Long.valueOf((long)time2)).sessions.size());
            pwriter.print(" expire at ");
            pwriter.print(new Date(time2));
            pwriter.println(":");
            for (SessionImpl s : this.sessionSets.get((Object)Long.valueOf((long)time2)).sessions) {
                pwriter.print("\t0x");
                pwriter.println(Long.toHexString(s.sessionId));
            }
        }
    }

    @Override
    public synchronized String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pwriter = new PrintWriter(sw);
        this.dumpSessions(pwriter);
        pwriter.flush();
        pwriter.close();
        return sw.toString();
    }

    @Override
    public synchronized void run() {
        try {
            while (this.running) {
                this.currentTime = Time.currentElapsedTime();
                if (this.nextExpirationTime > this.currentTime) {
                    this.wait(this.nextExpirationTime - this.currentTime);
                    continue;
                }
                SessionSet set2 = this.sessionSets.remove(this.nextExpirationTime);
                if (set2 != null) {
                    for (SessionImpl s : set2.sessions) {
                        this.setSessionClosing(s.sessionId);
                        this.expirer.expire(s);
                    }
                }
                this.nextExpirationTime += (long)this.expirationInterval;
            }
        }
        catch (InterruptedException e2) {
            this.handleException(this.getName(), e2);
        }
        LOG.info("SessionTrackerImpl exited loop!");
    }

    @Override
    public synchronized boolean touchSession(long sessionId, int timeout) {
        SessionImpl s;
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 8L, "SessionTrackerImpl --- Touch session: 0x" + Long.toHexString(sessionId) + " with timeout " + timeout);
        }
        if ((s = this.sessionsById.get(sessionId)) == null || s.isClosing()) {
            return false;
        }
        long expireTime = this.roundToInterval(Time.currentElapsedTime() + (long)timeout);
        if (s.tickTime >= expireTime) {
            return true;
        }
        SessionSet set2 = this.sessionSets.get(s.tickTime);
        if (set2 != null) {
            set2.sessions.remove(s);
        }
        s.tickTime = expireTime;
        set2 = this.sessionSets.get(s.tickTime);
        if (set2 == null) {
            set2 = new SessionSet();
            this.sessionSets.put(expireTime, set2);
        }
        set2.sessions.add(s);
        return true;
    }

    @Override
    public synchronized void setSessionClosing(long sessionId) {
        SessionImpl s;
        if (LOG.isTraceEnabled()) {
            LOG.info("Session closing: 0x" + Long.toHexString(sessionId));
        }
        if ((s = this.sessionsById.get(sessionId)) == null) {
            return;
        }
        s.isClosing = true;
    }

    @Override
    public synchronized void removeSession(long sessionId) {
        SessionSet set2;
        SessionImpl s = this.sessionsById.remove(sessionId);
        this.sessionsWithTimeout.remove(sessionId);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "SessionTrackerImpl --- Removing session 0x" + Long.toHexString(sessionId));
        }
        if (s != null && (set2 = this.sessionSets.get(s.tickTime)) != null) {
            set2.sessions.remove(s);
        }
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down");
        this.running = false;
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, ZooTrace.getTextTraceLevel(), "Shutdown SessionTrackerImpl!");
        }
    }

    @Override
    public synchronized long createSession(int sessionTimeout) {
        this.addSession(this.nextSessionId, sessionTimeout);
        return this.nextSessionId++;
    }

    @Override
    public synchronized void addSession(long id, int sessionTimeout) {
        this.sessionsWithTimeout.put(id, sessionTimeout);
        if (this.sessionsById.get(id) == null) {
            SessionImpl s = new SessionImpl(id, sessionTimeout, 0L);
            this.sessionsById.put(id, s);
            if (LOG.isTraceEnabled()) {
                ZooTrace.logTraceMessage(LOG, 32L, "SessionTrackerImpl --- Adding session 0x" + Long.toHexString(id) + " " + sessionTimeout);
            }
        } else if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "SessionTrackerImpl --- Existing session 0x" + Long.toHexString(id) + " " + sessionTimeout);
        }
        this.touchSession(id, sessionTimeout);
    }

    @Override
    public synchronized void checkSession(long sessionId, Object owner) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException {
        SessionImpl session = this.sessionsById.get(sessionId);
        if (session == null || session.isClosing()) {
            throw new KeeperException.SessionExpiredException();
        }
        if (session.owner == null) {
            session.owner = owner;
        } else if (session.owner != owner) {
            throw new KeeperException.SessionMovedException();
        }
    }

    @Override
    public synchronized void setOwner(long id, Object owner) throws KeeperException.SessionExpiredException {
        SessionImpl session = this.sessionsById.get(id);
        if (session == null || session.isClosing()) {
            throw new KeeperException.SessionExpiredException();
        }
        session.owner = owner;
    }

    static class SessionSet {
        HashSet<SessionImpl> sessions = new HashSet();

        SessionSet() {
        }
    }

    public static class SessionImpl
    implements SessionTracker.Session {
        final long sessionId;
        final int timeout;
        long tickTime;
        boolean isClosing;
        Object owner;

        SessionImpl(long sessionId, int timeout, long expireTime) {
            this.sessionId = sessionId;
            this.timeout = timeout;
            this.tickTime = expireTime;
            this.isClosing = false;
        }

        @Override
        public long getSessionId() {
            return this.sessionId;
        }

        @Override
        public int getTimeout() {
            return this.timeout;
        }

        @Override
        public boolean isClosing() {
            return this.isClosing;
        }
    }
}

