/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.ipfilter;

import io.mantisrx.shaded.org.jboss.netty.channel.ChannelEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFuture;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFutureListener;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelStateEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelUpstreamHandler;
import io.mantisrx.shaded.org.jboss.netty.channel.Channels;
import io.mantisrx.shaded.org.jboss.netty.handler.ipfilter.IpFilterListener;
import io.mantisrx.shaded.org.jboss.netty.handler.ipfilter.IpFilteringHandler;
import java.net.InetSocketAddress;

public abstract class IpFilteringHandlerImpl
implements ChannelUpstreamHandler,
IpFilteringHandler {
    private IpFilterListener listener;

    protected abstract boolean accept(ChannelHandlerContext var1, ChannelEvent var2, InetSocketAddress var3) throws Exception;

    protected ChannelFuture handleRefusedChannel(ChannelHandlerContext ctx, ChannelEvent e2, InetSocketAddress inetSocketAddress) throws Exception {
        if (this.listener == null) {
            return null;
        }
        return this.listener.refused(ctx, e2, inetSocketAddress);
    }

    protected ChannelFuture handleAllowedChannel(ChannelHandlerContext ctx, ChannelEvent e2, InetSocketAddress inetSocketAddress) throws Exception {
        if (this.listener == null) {
            return null;
        }
        return this.listener.allowed(ctx, e2, inetSocketAddress);
    }

    protected boolean isBlocked(ChannelHandlerContext ctx) {
        return ctx.getAttachment() != null;
    }

    protected boolean continues(ChannelHandlerContext ctx, ChannelEvent e2) throws Exception {
        if (this.listener != null) {
            return this.listener.continues(ctx, e2);
        }
        return false;
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e2) throws Exception {
        if (e2 instanceof ChannelStateEvent) {
            ChannelStateEvent evt = (ChannelStateEvent)e2;
            switch (evt.getState()) {
                case OPEN: 
                case BOUND: {
                    if (this.isBlocked(ctx) && !this.continues(ctx, evt)) {
                        return;
                    }
                    ctx.sendUpstream(e2);
                    return;
                }
                case CONNECTED: {
                    if (evt.getValue() != null) {
                        InetSocketAddress inetSocketAddress = (InetSocketAddress)e2.getChannel().getRemoteAddress();
                        if (!this.accept(ctx, e2, inetSocketAddress)) {
                            ctx.setAttachment(Boolean.TRUE);
                            ChannelFuture future2 = this.handleRefusedChannel(ctx, e2, inetSocketAddress);
                            if (future2 != null) {
                                future2.addListener(ChannelFutureListener.CLOSE);
                            } else {
                                Channels.close(e2.getChannel());
                            }
                            if (this.isBlocked(ctx) && !this.continues(ctx, evt)) {
                                return;
                            }
                        } else {
                            this.handleAllowedChannel(ctx, e2, inetSocketAddress);
                        }
                        ctx.setAttachment(null);
                        break;
                    }
                    if (!this.isBlocked(ctx) || this.continues(ctx, evt)) break;
                    return;
                }
            }
        }
        if (this.isBlocked(ctx) && !this.continues(ctx, e2)) {
            return;
        }
        ctx.sendUpstream(e2);
    }

    public void setIpFilterListener(IpFilterListener listener) {
        this.listener = listener;
    }

    public void removeIpFilterListener() {
        this.listener = null;
    }
}

