/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.util.internal;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public final class ByteBufferUtil {
    private static final boolean CLEAN_SUPPORTED;
    private static final Method directBufferCleaner;
    private static final Method directBufferCleanerClean;

    public static void destroy(ByteBuffer buffer) {
        if (CLEAN_SUPPORTED && buffer.isDirect()) {
            try {
                Object cleaner = directBufferCleaner.invoke((Object)buffer, new Object[0]);
                directBufferCleanerClean.invoke(cleaner, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ByteBufferUtil() {
    }

    static {
        boolean v;
        Method directBufferCleanerX = null;
        Method directBufferCleanerCleanX = null;
        try {
            directBufferCleanerX = Class.forName("java.nio.DirectByteBuffer").getMethod("cleaner", new Class[0]);
            directBufferCleanerX.setAccessible(true);
            directBufferCleanerCleanX = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
            directBufferCleanerCleanX.setAccessible(true);
            v = true;
        }
        catch (Exception e2) {
            v = false;
        }
        CLEAN_SUPPORTED = v;
        directBufferCleaner = directBufferCleanerX;
        directBufferCleanerClean = directBufferCleanerCleanX;
    }
}

