/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.collection.ArrayType;
import io.vavr.collection.Collections;
import io.vavr.collection.Iterator;
import io.vavr.collection.LeafVisitor;
import io.vavr.collection.NodeModifier;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;

final class BitMappedTrie<T>
implements Serializable {
    static final int BRANCHING_BASE = 5;
    static final int BRANCHING_FACTOR = 32;
    static final int BRANCHING_MASK = 31;
    private static final long serialVersionUID = 1L;
    private static final BitMappedTrie<?> EMPTY = new BitMappedTrie(ArrayType.obj(), ArrayType.obj().empty(), 0, 0, 0);
    final ArrayType<T> type;
    private final Object array;
    private final int offset;
    private final int length;
    private final int depthShift;

    static int firstDigit(int num2, int depthShift) {
        return num2 >> depthShift;
    }

    static int digit(int num2, int depthShift) {
        return BitMappedTrie.lastDigit(BitMappedTrie.firstDigit(num2, depthShift));
    }

    static int lastDigit(int num2) {
        return num2 & 0x1F;
    }

    static <T> BitMappedTrie<T> empty() {
        return EMPTY;
    }

    private BitMappedTrie(ArrayType<T> type2, Object array2, int offset, int length, int depthShift) {
        this.type = type2;
        this.array = array2;
        this.offset = offset;
        this.length = length;
        this.depthShift = depthShift;
    }

    private static int treeSize(int branchCount, int depthShift) {
        int fullBranchSize = 1 << depthShift;
        return branchCount * fullBranchSize;
    }

    static <T> BitMappedTrie<T> ofAll(Object array2) {
        ArrayType type2 = ArrayType.of(array2);
        int size = type2.lengthOf(array2);
        return size == 0 ? BitMappedTrie.empty() : BitMappedTrie.ofAll(array2, type2, size);
    }

    private static <T> BitMappedTrie<T> ofAll(Object array2, ArrayType<T> type2, int size) {
        int shift = 0;
        ArrayType<T> t = type2;
        while (t.lengthOf(array2) > 32) {
            array2 = t.grouped(array2, 32);
            t = ArrayType.obj();
            shift += 5;
        }
        return new BitMappedTrie<T>(type2, array2, 0, size, shift);
    }

    private BitMappedTrie<T> boxed() {
        return this.map(Function.identity());
    }

    BitMappedTrie<T> prependAll(Iterable<? extends T> iterable) {
        Collections.IterableWithSize<T> iter = Collections.withSize(iterable);
        try {
            return this.prepend(iter.reverseIterator(), iter.size());
        }
        catch (ClassCastException ignored) {
            return super.prepend(iter.reverseIterator(), iter.size());
        }
    }

    private BitMappedTrie<T> prepend(java.util.Iterator<? extends T> iterator, int size) {
        BitMappedTrie<? extends T> result = this;
        while (size > 0) {
            Object array2 = result.array;
            int shift = result.depthShift;
            int offset = result.offset;
            if (result.isFullLeft()) {
                array2 = ArrayType.obj().copyUpdate(ArrayType.obj().empty(), 31, array2);
                offset = BitMappedTrie.treeSize(31, shift += 5);
            }
            int index2 = offset - 1;
            int delta = Math.min(size, BitMappedTrie.lastDigit(index2) + 1);
            size -= delta;
            array2 = result.modify(array2, shift, index2, NodeModifier.COPY_NODE, this.prependToLeaf(iterator));
            result = new BitMappedTrie<T>(this.type, array2, offset - delta, result.length + delta, shift);
        }
        return result;
    }

    private boolean isFullLeft() {
        return this.offset == 0;
    }

    private NodeModifier prependToLeaf(java.util.Iterator<? extends T> iterator) {
        return (array2, index2) -> {
            Object copy2 = this.type.copy(array2, 32);
            while (iterator.hasNext() && index2 >= 0) {
                this.type.setAt(copy2, index2--, iterator.next());
            }
            return copy2;
        };
    }

    BitMappedTrie<T> appendAll(Iterable<? extends T> iterable) {
        Collections.IterableWithSize<T> iter = Collections.withSize(iterable);
        try {
            return this.append(iter.iterator(), iter.size());
        }
        catch (ClassCastException ignored) {
            return super.append(iter.iterator(), iter.size());
        }
    }

    private BitMappedTrie<T> append(java.util.Iterator<? extends T> iterator, int size) {
        BitMappedTrie<? extends T> result = this;
        while (size > 0) {
            Object array2 = result.array;
            int shift = result.depthShift;
            if (result.isFullRight()) {
                array2 = ArrayType.obj().asArray(array2);
                shift += 5;
            }
            int index2 = this.offset + result.length;
            int leafSpace = BitMappedTrie.lastDigit(index2);
            int delta = Math.min(size, 32 - leafSpace);
            size -= delta;
            array2 = result.modify(array2, shift, index2, NodeModifier.COPY_NODE, this.appendToLeaf(iterator, leafSpace + delta));
            result = new BitMappedTrie<T>(this.type, array2, this.offset, result.length + delta, shift);
        }
        return result;
    }

    private boolean isFullRight() {
        return this.offset + this.length + 1 > BitMappedTrie.treeSize(32, this.depthShift);
    }

    private NodeModifier appendToLeaf(java.util.Iterator<? extends T> iterator, int leafSize) {
        return (array2, index2) -> {
            Object copy2 = this.type.copy(array2, leafSize);
            while (iterator.hasNext() && index2 < leafSize) {
                this.type.setAt(copy2, index2++, iterator.next());
            }
            return copy2;
        };
    }

    BitMappedTrie<T> update(int index2, T element) {
        try {
            Object root2 = this.modify(this.array, this.depthShift, this.offset + index2, NodeModifier.COPY_NODE, this.updateLeafWith(this.type, element));
            return new BitMappedTrie<T>(this.type, root2, this.offset, this.length, this.depthShift);
        }
        catch (ClassCastException ignored) {
            return this.boxed().update(index2, element);
        }
    }

    private NodeModifier updateLeafWith(ArrayType<T> type2, T element) {
        return (a, i) -> type2.copyUpdate(a, i, element);
    }

    BitMappedTrie<T> drop(int n) {
        if (n <= 0) {
            return this;
        }
        if (n >= this.length) {
            return BitMappedTrie.empty();
        }
        int index2 = this.offset + n;
        Object root2 = this.arePointingToSameLeaf(0, n) ? this.array : this.modify(this.array, this.depthShift, index2, ArrayType.obj()::copyDrop, NodeModifier.IDENTITY);
        return BitMappedTrie.collapsed(this.type, root2, index2, this.length - n, this.depthShift);
    }

    BitMappedTrie<T> take(int n) {
        if (n >= this.length) {
            return this;
        }
        if (n <= 0) {
            return BitMappedTrie.empty();
        }
        int index2 = n - 1;
        Object root2 = this.arePointingToSameLeaf(index2, this.length - 1) ? this.array : this.modify(this.array, this.depthShift, this.offset + index2, ArrayType.obj()::copyTake, NodeModifier.IDENTITY);
        return BitMappedTrie.collapsed(this.type, root2, this.offset, n, this.depthShift);
    }

    private boolean arePointingToSameLeaf(int i, int j) {
        return BitMappedTrie.firstDigit(this.offset + i, 5) == BitMappedTrie.firstDigit(this.offset + j, 5);
    }

    private static <T> BitMappedTrie<T> collapsed(ArrayType<T> type2, Object array2, int offset, int length, int shift) {
        int skippedElements;
        while (shift > 0 && (skippedElements = ArrayType.obj().lengthOf(array2) - 1) == BitMappedTrie.digit(offset, shift)) {
            array2 = ArrayType.obj().getAt(array2, skippedElements);
            offset -= BitMappedTrie.treeSize(skippedElements, shift);
            shift -= 5;
        }
        return new BitMappedTrie<T>(type2, array2, offset, length, shift);
    }

    private Object modify(Object root2, int depthShift, int index2, NodeModifier node2, NodeModifier leaf) {
        return depthShift == 0 ? leaf.apply(root2, index2) : this.modifyNonLeaf(root2, depthShift, index2, node2, leaf);
    }

    private Object modifyNonLeaf(Object root2, int depthShift, int index2, NodeModifier node2, NodeModifier leaf) {
        int previousIndex = BitMappedTrie.firstDigit(index2, depthShift);
        Object array2 = root2 = node2.apply(root2, previousIndex);
        for (int shift = depthShift - 5; shift >= 5; shift -= 5) {
            int prev2 = previousIndex;
            previousIndex = BitMappedTrie.digit(index2, shift);
            array2 = this.setNewNode(node2, prev2, array2, previousIndex);
        }
        Object newLeaf = leaf.apply(ArrayType.obj().getAt(array2, previousIndex), BitMappedTrie.lastDigit(index2));
        ArrayType.obj().setAt(array2, previousIndex, newLeaf);
        return root2;
    }

    private Object setNewNode(NodeModifier node2, int previousIndex, Object array2, int offset) {
        Object previous = ArrayType.obj().getAt(array2, previousIndex);
        Object newNode = node2.apply(previous, offset);
        ArrayType.obj().setAt(array2, previousIndex, newNode);
        return newNode;
    }

    T get(int index2) {
        Object leaf = this.getLeaf(index2);
        int leafIndex = BitMappedTrie.lastDigit(this.offset + index2);
        return this.type.getAt(leaf, leafIndex);
    }

    Object getLeaf(int index2) {
        if (this.depthShift == 0) {
            return this.array;
        }
        return this.getLeafGeneral(index2);
    }

    private Object getLeafGeneral(int index2) {
        Object leaf = ArrayType.obj().getAt(this.array, BitMappedTrie.firstDigit(index2 += this.offset, this.depthShift));
        for (int shift = this.depthShift - 5; shift > 0; shift -= 5) {
            leaf = ArrayType.obj().getAt(leaf, BitMappedTrie.digit(index2, shift));
        }
        return leaf;
    }

    Iterator<T> iterator() {
        return new Iterator<T>(){
            private final int globalLength;
            private int globalIndex;
            private int index;
            private Object leaf;
            private int length;
            {
                this.globalLength = BitMappedTrie.this.length;
                this.globalIndex = 0;
                this.index = BitMappedTrie.lastDigit(BitMappedTrie.this.offset);
                this.leaf = BitMappedTrie.this.getLeaf(this.globalIndex);
                this.length = BitMappedTrie.this.type.lengthOf(this.leaf);
            }

            @Override
            public boolean hasNext() {
                return this.globalIndex < this.globalLength;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() on empty iterator");
                }
                if (this.index == this.length) {
                    this.setCurrentArray();
                }
                Object next2 = BitMappedTrie.this.type.getAt(this.leaf, this.index);
                ++this.index;
                ++this.globalIndex;
                return next2;
            }

            private void setCurrentArray() {
                this.index = 0;
                this.leaf = BitMappedTrie.this.getLeaf(this.globalIndex);
                this.length = BitMappedTrie.this.type.lengthOf(this.leaf);
            }
        };
    }

    <T2> int visit(LeafVisitor<T2> visitor) {
        int end;
        int globalIndex = 0;
        int start = BitMappedTrie.lastDigit(this.offset);
        for (int index2 = 0; index2 < this.length; index2 += end - start) {
            Object leaf = this.getLeaf(index2);
            end = this.getMin(start, index2, leaf);
            globalIndex = visitor.visit(globalIndex, leaf, start, end);
            start = 0;
        }
        return globalIndex;
    }

    private int getMin(int start, int index2, Object leaf) {
        return Math.min(this.type.lengthOf(leaf), start + this.length - index2);
    }

    BitMappedTrie<T> filter(Predicate<? super T> predicate) {
        Object results = this.type.newInstance(this.length());
        int length = this.visit((index2, leaf, start, end) -> this.filter(predicate, results, index2, leaf, start, end));
        return this.length == length ? this : BitMappedTrie.ofAll(this.type.copyRange(results, 0, length));
    }

    private int filter(Predicate<? super T> predicate, Object results, int index2, T leaf, int start, int end) {
        for (int i = start; i < end; ++i) {
            T value = this.type.getAt(leaf, i);
            if (!predicate.test(value)) continue;
            this.type.setAt(results, index2++, value);
        }
        return index2;
    }

    <U> BitMappedTrie<U> map(Function<? super T, ? extends U> mapper) {
        Object results = ArrayType.obj().newInstance(this.length);
        this.visit((index2, leaf, start, end) -> this.map(mapper, results, index2, leaf, start, end));
        return BitMappedTrie.ofAll(results);
    }

    private <U> int map(Function<? super T, ? extends U> mapper, Object results, int index2, T leaf, int start, int end) {
        for (int i = start; i < end; ++i) {
            ArrayType.obj().setAt(results, index2++, mapper.apply(this.type.getAt(leaf, i)));
        }
        return index2;
    }

    int length() {
        return this.length;
    }
}

