/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Traversable;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;

final class PriorityQueueBase {
    PriorityQueueBase() {
    }

    static <T> Tuple2<T, Seq<Node<T>>> deleteMin(Comparator<? super T> comparator2, Seq<Node<T>> forest) {
        Node<? super T> minTree = PriorityQueueBase.findMin(comparator2, forest);
        Seq<Node<T>> forestTail = minTree == forest.head() ? forest.tail() : forest.remove(minTree);
        Seq<Node<T>> newForest = PriorityQueueBase.rebuild(comparator2, minTree.children);
        return Tuple.of(minTree.root, PriorityQueueBase.meld(comparator2, newForest, forestTail));
    }

    static <T> Seq<Node<T>> insert(Comparator<? super T> comparator2, T element, Seq<Node<T>> forest) {
        Node<Object> tree = Node.of(element, 0, List.empty());
        if (forest.size() >= 2) {
            Traversable tail = forest.tail();
            Node t1 = (Node)forest.head();
            Node t2 = (Node)tail.head();
            if (t1.rank == t2.rank) {
                return tree.skewLink(comparator2, t1, t2).appendTo((Seq<Node<T>>)tail.tail());
            }
        }
        return tree.appendTo(forest);
    }

    static <T> Seq<Node<T>> meld(Comparator<? super T> comparator2, Seq<Node<T>> source2, Seq<Node<T>> target) {
        return PriorityQueueBase.meldUnique(comparator2, PriorityQueueBase.uniqify(comparator2, source2), PriorityQueueBase.uniqify(comparator2, target));
    }

    static <T> Node<T> findMin(Comparator<? super T> comparator2, Seq<Node<T>> forest) {
        Iterator iterator = forest.iterator();
        Node min2 = (Node)iterator.next();
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            Node node2 = (Node)iterator2.next();
            if (comparator2.compare(node2.root, min2.root) >= 0) continue;
            min2 = node2;
        }
        return min2;
    }

    private static <T> Seq<Node<T>> rebuild(Comparator<? super T> comparator2, Seq<Node<T>> forest) {
        Seq<Node<T>> nonZeroRank = List.empty();
        Seq<Node<Object>> zeroRank = List.empty();
        while (!forest.isEmpty()) {
            Node initialForestHead = (Node)forest.head();
            if (initialForestHead.rank == 0) {
                zeroRank = PriorityQueueBase.insert(comparator2, initialForestHead.root, zeroRank);
            } else {
                nonZeroRank = initialForestHead.appendTo(nonZeroRank);
            }
            forest = forest.tail();
        }
        return PriorityQueueBase.meld(comparator2, nonZeroRank, zeroRank);
    }

    private static <T> Seq<Node<T>> uniqify(Comparator<? super T> comparator2, Seq<Node<T>> forest) {
        return forest.isEmpty() ? forest : PriorityQueueBase.ins(comparator2, (Node)forest.head(), forest.tail());
    }

    private static <T> Seq<Node<T>> ins(Comparator<? super T> comparator2, Node<T> tree, Seq<Node<T>> forest) {
        while (!forest.isEmpty() && tree.rank == ((Node)forest.head()).rank) {
            tree = tree.link(comparator2, (Node)forest.head());
            forest = forest.tail();
        }
        return tree.appendTo((Seq<Node<Object>>)forest);
    }

    private static <T> Seq<Node<T>> meldUnique(Comparator<? super T> comparator2, Seq<Node<T>> forest1, Seq<Node<T>> forest2) {
        if (forest1.isEmpty()) {
            return forest2;
        }
        if (forest2.isEmpty()) {
            return forest1;
        }
        Node tree1 = (Node)forest1.head();
        Node tree2 = (Node)forest2.head();
        if (tree1.rank == tree2.rank) {
            Node<? super T> tree = tree1.link(comparator2, tree2);
            Seq<Node<T>> forest = PriorityQueueBase.meldUnique(comparator2, forest1.tail(), forest2.tail());
            return PriorityQueueBase.ins(comparator2, tree, forest);
        }
        if (tree1.rank < tree2.rank) {
            Seq forest = PriorityQueueBase.meldUnique(comparator2, forest1.tail(), forest2);
            return tree1.appendTo(forest);
        }
        Seq forest = PriorityQueueBase.meldUnique(comparator2, forest1, forest2.tail());
        return tree2.appendTo(forest);
    }

    static final class Node<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final T root;
        final int rank;
        final Seq<Node<T>> children;

        private Node(T root2, int rank, Seq<Node<T>> children2) {
            this.root = root2;
            this.rank = rank;
            this.children = children2;
        }

        static <T> Node<T> of(T value, int rank, Seq<Node<T>> children2) {
            return new Node<T>(value, rank, children2);
        }

        Node<T> link(Comparator<? super T> comparator2, Node<T> tree) {
            return comparator2.compare(this.root, tree.root) <= 0 ? Node.of(this.root, this.rank + 1, tree.appendTo(this.children)) : Node.of(tree.root, tree.rank + 1, this.appendTo(tree.children));
        }

        Node<T> skewLink(Comparator<? super T> comparator2, Node<T> left2, Node<T> right2) {
            if (comparator2.compare(left2.root, this.root) <= 0 && comparator2.compare(left2.root, right2.root) <= 0) {
                return Node.of(left2.root, left2.rank + 1, this.appendTo(right2.appendTo(left2.children)));
            }
            if (comparator2.compare(right2.root, this.root) <= 0) {
                return Node.of(right2.root, right2.rank + 1, this.appendTo(left2.appendTo(right2.children)));
            }
            return Node.of(this.root, left2.rank + 1, List.of(left2, right2));
        }

        Seq<Node<T>> appendTo(Seq<Node<T>> forest) {
            return forest.prepend(this);
        }
    }
}

