/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text.translate;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.text.translate.CodePointTranslator;

public class UnicodeEscaper
extends CodePointTranslator {
    private final int below;
    private final int above;
    private final boolean between;

    public UnicodeEscaper() {
        this(0, Integer.MAX_VALUE, true);
    }

    protected UnicodeEscaper(int below, int above, boolean between) {
        this.below = below;
        this.above = above;
        this.between = between;
    }

    public static UnicodeEscaper below(int codepoint2) {
        return UnicodeEscaper.outsideOf(codepoint2, Integer.MAX_VALUE);
    }

    public static UnicodeEscaper above(int codepoint2) {
        return UnicodeEscaper.outsideOf(0, codepoint2);
    }

    public static UnicodeEscaper outsideOf(int codepointLow, int codepointHigh) {
        return new UnicodeEscaper(codepointLow, codepointHigh, false);
    }

    public static UnicodeEscaper between(int codepointLow, int codepointHigh) {
        return new UnicodeEscaper(codepointLow, codepointHigh, true);
    }

    @Override
    public boolean translate(int codepoint2, Writer out) throws IOException {
        if (this.between ? codepoint2 < this.below || codepoint2 > this.above : codepoint2 >= this.below && codepoint2 <= this.above) {
            return false;
        }
        if (codepoint2 > 65535) {
            out.write(this.toUtf16Escape(codepoint2));
        } else if (codepoint2 > 4095) {
            out.write("\\u" + UnicodeEscaper.hex(codepoint2));
        } else if (codepoint2 > 255) {
            out.write("\\u0" + UnicodeEscaper.hex(codepoint2));
        } else if (codepoint2 > 15) {
            out.write("\\u00" + UnicodeEscaper.hex(codepoint2));
        } else {
            out.write("\\u000" + UnicodeEscaper.hex(codepoint2));
        }
        return true;
    }

    protected String toUtf16Escape(int codepoint2) {
        return "\\u" + UnicodeEscaper.hex(codepoint2);
    }
}

