/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.PropertyDetails;
import com.netflix.archaius.config.AbstractConfig;
import com.netflix.archaius.config.CachedState;
import java.util.Iterator;
import java.util.function.BiConsumer;

public abstract class AbstractDependentConfig
extends AbstractConfig {
    public AbstractDependentConfig(String name2) {
        super(name2);
    }

    public AbstractDependentConfig() {
    }

    abstract CachedState getState();

    @Override
    public Object getRawProperty(String key2) {
        Object value = this.getState().getData().get(key2);
        if (this.getState().getInstrumentedKeys().containsKey(key2)) {
            this.getState().getInstrumentedKeys().get(key2).recordUsage(this.createPropertyDetails(key2, value));
        }
        return value;
    }

    @Override
    public Object getRawPropertyUninstrumented(String key2) {
        return this.getState().getData().get(key2);
    }

    @Override
    public Iterator<String> getKeys() {
        return this.getState().getData().keySet().iterator();
    }

    @Override
    public Iterable<String> keys() {
        return this.getState().getData().keySet();
    }

    @Override
    public void forEachProperty(BiConsumer<String, Object> consumer) {
        this.getState().getData().forEach((k, v) -> {
            if (this.getState().getInstrumentedKeys().containsKey(k)) {
                this.getState().getInstrumentedKeys().get(k).recordUsage(this.createPropertyDetails((String)k, v));
            }
            consumer.accept((String)k, v);
        });
    }

    @Override
    public void forEachPropertyUninstrumented(BiConsumer<String, Object> consumer) {
        this.getState().getData().forEach(consumer);
    }

    @Override
    public boolean containsKey(String key2) {
        return this.getState().getData().containsKey(key2);
    }

    @Override
    public boolean isEmpty() {
        return this.getState().getData().isEmpty();
    }

    @Override
    public void recordUsage(PropertyDetails propertyDetails) {
        if (this.getState().getInstrumentedKeys().containsKey(propertyDetails.getKey())) {
            this.getState().getInstrumentedKeys().get(propertyDetails.getKey()).recordUsage(propertyDetails);
        }
    }

    @Override
    public boolean instrumentationEnabled() {
        return !this.getState().getInstrumentedKeys().isEmpty();
    }

    protected PropertyDetails createPropertyDetails(String key2, Object value) {
        return new PropertyDetails(key2, null, value);
    }
}

