/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.netty.pipeline;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.impl.AtomicDouble;
import io.mantisrx.publish.config.MrePublishConfiguration;
import io.mantisrx.publish.internal.metrics.SpectatorUtils;
import io.mantisrx.publish.netty.pipeline.HttpEventChannel;
import io.mantisrx.publish.netty.pipeline.HttpEventChannelInitializer;
import io.mantisrx.publish.netty.pipeline.MantisMessageSizeEstimator;
import io.mantisrx.shaded.io.netty.bootstrap.Bootstrap;
import io.mantisrx.shaded.io.netty.channel.Channel;
import io.mantisrx.shaded.io.netty.channel.ChannelFuture;
import io.mantisrx.shaded.io.netty.channel.ChannelOption;
import io.mantisrx.shaded.io.netty.channel.DefaultEventLoopGroup;
import io.mantisrx.shaded.io.netty.channel.EventLoopGroup;
import io.mantisrx.shaded.io.netty.channel.WriteBufferWaterMark;
import io.mantisrx.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.mantisrx.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import io.mantisrx.shaded.io.netty.util.concurrent.Future;
import io.mantisrx.shaded.io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpEventChannelManager {
    private static final Logger LOG = LoggerFactory.getLogger(HttpEventChannel.class);
    private final Counter connectionSuccess;
    private final Counter connectionFailure;
    private final AtomicDouble liveConnections;
    private final AtomicDouble nettyChannelBufferSize;
    private final int lowWriteBufferWatermark;
    private final int highWriteBufferWatermark;
    private final EventLoopGroup eventLoopGroup;
    private final EventLoopGroup encoderEventLoopGroup;
    private final Bootstrap bootstrap;
    private final ConcurrentMap<String, Channel> channels;

    public HttpEventChannelManager(Registry registry, MrePublishConfiguration config) {
        this.connectionSuccess = SpectatorUtils.buildAndRegisterCounter(registry, "connectionSuccess", "channel", "netty");
        this.connectionFailure = SpectatorUtils.buildAndRegisterCounter(registry, "connectionFailure", "channel", "netty");
        this.liveConnections = SpectatorUtils.buildAndRegisterGauge(registry, "liveConnections", "channel", "netty");
        this.nettyChannelBufferSize = SpectatorUtils.buildAndRegisterGauge(registry, "bufferSize", "channel", "netty");
        this.lowWriteBufferWatermark = config.getLowWriteBufferWatermark();
        this.highWriteBufferWatermark = config.getHighWriteBufferWatermark();
        this.eventLoopGroup = new NioEventLoopGroup(config.getIoThreads());
        boolean gzipEnabled = config.getGzipEnabled();
        this.encoderEventLoopGroup = gzipEnabled ? new DefaultEventLoopGroup(config.getCompressionThreads()) : null;
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.MESSAGE_SIZE_ESTIMATOR, MantisMessageSizeEstimator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, new WriteBufferWaterMark(this.lowWriteBufferWatermark, this.highWriteBufferWatermark))).handler(new HttpEventChannelInitializer(registry, config, this.encoderEventLoopGroup));
        this.channels = new ConcurrentHashMap<String, Channel>();
        Runtime.getRuntime().addShutdownHook(new Thread(this.eventLoopGroup::shutdownGracefully));
    }

    Channel findOrCreate(InetSocketAddress address) {
        Channel channel = this.find(address);
        if (channel == null) {
            LOG.debug("creating new channel for {}", (Object)address);
            ChannelFuture channelFuture = this.bootstrap.connect(address);
            channel = channelFuture.channel();
            this.channels.put(this.getHostPortString(address), channel);
            channel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future2 -> {
                LOG.debug("closing channel for {}", (Object)address);
                this.channels.remove(this.getHostPortString(address));
                this.liveConnections.set((double)this.channels.size());
            }));
            channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future2 -> {
                if (future2.isSuccess()) {
                    LOG.debug("connection success for {}", (Object)address);
                    this.connectionSuccess.increment();
                    this.liveConnections.set((double)this.channels.size());
                } else {
                    LOG.debug("failed to connect to {}", (Object)address);
                    this.connectionFailure.increment();
                }
            }));
        }
        this.nettyChannelBufferSize.set((double)((long)this.highWriteBufferWatermark - channel.bytesBeforeUnwritable()));
        return channel;
    }

    private Channel find(InetSocketAddress address) {
        return (Channel)this.channels.get(this.getHostPortString(address));
    }

    void close(InetSocketAddress address) {
        Channel channel = this.find(address);
        if (channel != null) {
            channel.close();
        }
    }

    private String getHostPortString(InetSocketAddress address) {
        return address.getHostString() + ':' + address.getPort();
    }
}

