/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.publish.netty.transmitters;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.impl.AtomicDouble;
import io.mantisrx.discovery.proto.MantisWorker;
import io.mantisrx.publish.EventChannel;
import io.mantisrx.publish.api.Event;
import io.mantisrx.publish.config.MrePublishConfiguration;
import io.mantisrx.publish.internal.exceptions.NonRetryableException;
import io.mantisrx.publish.internal.metrics.SpectatorUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;

class ChoiceOfTwoWorkerPool {
    private final Registry registry;
    private final AtomicDouble workerPoolGauge;
    private final AtomicDouble blacklistedWorkersGauge;
    private final int capacity;
    private final int errorQuota;
    private final int errorTimeoutSec;
    private final int refreshIntervalSec;
    private final ConcurrentMap<MantisWorker, Integer> pool;
    private final Set<MantisWorker> blacklist;
    private final EventChannel eventChannel;
    private AtomicLong lastFetchMs;
    private AtomicLong lastBlacklistRefreshMs;

    ChoiceOfTwoWorkerPool(MrePublishConfiguration config, Registry registry, EventChannel eventChannel) {
        this.registry = registry;
        this.workerPoolGauge = SpectatorUtils.buildAndRegisterGauge(registry, "workerPool", "channel", "netty");
        this.blacklistedWorkersGauge = SpectatorUtils.buildAndRegisterGauge(registry, "blacklistedWorkers", "channel", "netty");
        this.capacity = config.getWorkerPoolCapacity();
        this.errorQuota = config.getWorkerPoolWorkerErrorQuota();
        this.errorTimeoutSec = config.getWorkerPoolWorkerErrorTimeoutSec();
        this.refreshIntervalSec = config.getWorkerPoolRefreshIntervalSec();
        this.pool = new ConcurrentHashMap<MantisWorker, Integer>(config.getWorkerPoolCapacity());
        this.blacklist = ConcurrentHashMap.newKeySet();
        this.eventChannel = eventChannel;
        this.lastFetchMs = new AtomicLong(0L);
        this.lastBlacklistRefreshMs = new AtomicLong(0L);
    }

    void refresh(List<MantisWorker> freshWorkers, boolean force2) {
        if (!this.shouldRefresh(this.lastFetchMs.get(), this.refreshIntervalSec * 1000)) {
            return;
        }
        if (force2) {
            this.pool.clear();
            this.workerPoolGauge.set((double)this.pool.size());
        }
        if (this.shouldRefresh(this.lastBlacklistRefreshMs.get(), this.errorTimeoutSec * 1000)) {
            this.blacklist.clear();
            this.blacklistedWorkersGauge.set((double)this.blacklist.size());
            this.lastBlacklistRefreshMs.set(this.registry.clock().wallTime());
        }
        HashSet staleWorkers = new HashSet(this.pool.keySet());
        HashSet diff2 = new HashSet(staleWorkers);
        staleWorkers.retainAll(freshWorkers);
        diff2.removeAll(staleWorkers);
        diff2.forEach(this.pool::remove);
        freshWorkers.removeAll(diff2);
        Iterator<MantisWorker> candidates = freshWorkers.iterator();
        while (candidates.hasNext() && this.pool.size() < this.capacity) {
            MantisWorker candidate = candidates.next();
            if (this.blacklist.contains(candidate)) continue;
            this.pool.put(candidate, 0);
            this.workerPoolGauge.set((double)this.pool.size());
        }
        this.lastFetchMs.set(this.registry.clock().wallTime());
    }

    void refresh(List<MantisWorker> workers) {
        this.refresh(workers, false);
    }

    private boolean shouldRefresh(long timestamp, long interval) {
        return this.registry.clock().wallTime() - timestamp > interval;
    }

    CompletableFuture<Void> record(Event event, BiFunction<MantisWorker, Event, CompletableFuture<Void>> function) throws NonRetryableException {
        MantisWorker worker = this.getRandomWorker();
        if (worker == null) {
            throw new NonRetryableException("no available workers in pool");
        }
        CompletableFuture<Void> future2 = function.apply(worker, event);
        future2.whenCompleteAsync((v, t) -> {
            if (t != null) {
                this.pool.put(worker, (Integer)this.pool.get(worker) + 1);
                if (this.shouldBlacklist(worker)) {
                    this.eventChannel.close(worker);
                    this.pool.remove(worker);
                    this.workerPoolGauge.set((double)this.pool.size());
                    this.blacklist.add(worker);
                    this.blacklistedWorkersGauge.set((double)this.blacklist.size());
                }
            }
        });
        return future2;
    }

    private boolean shouldBlacklist(MantisWorker worker) {
        return this.pool.getOrDefault(worker, 0) > this.errorQuota;
    }

    boolean isBlacklisted(MantisWorker worker) {
        return this.blacklist.contains(worker);
    }

    MantisWorker getRandomWorker() {
        double candidate2Score;
        int poolSize = this.pool.size();
        if (poolSize == 0) {
            return null;
        }
        if (poolSize == 1) {
            return (MantisWorker)this.pool.keySet().toArray()[0];
        }
        ArrayList candidates = new ArrayList(this.pool.keySet());
        int randomIndex1 = ThreadLocalRandom.current().nextInt(this.pool.size());
        int randomIndex2 = ThreadLocalRandom.current().nextInt(this.pool.size());
        MantisWorker candidate1 = (MantisWorker)candidates.get(randomIndex1);
        MantisWorker candidate2 = (MantisWorker)candidates.get(randomIndex2);
        double candidate1Score = this.getWorkerScore(candidate1);
        return candidate1Score <= (candidate2Score = this.getWorkerScore(candidate2)) ? candidate1 : candidate2;
    }

    int getWorkerErrors(MantisWorker worker) {
        return this.pool.getOrDefault(worker, 0);
    }

    private double getWorkerScore(MantisWorker worker) {
        return this.eventChannel.bufferSize(worker);
    }

    int size() {
        return this.pool.size();
    }

    int capacity() {
        return this.capacity;
    }
}

