/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.handler.codec.dns;

import io.mantisrx.shaded.io.netty.buffer.ByteBuf;
import io.mantisrx.shaded.io.netty.channel.ChannelHandler;
import io.mantisrx.shaded.io.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.io.netty.channel.socket.DatagramPacket;
import io.mantisrx.shaded.io.netty.handler.codec.CorruptedFrameException;
import io.mantisrx.shaded.io.netty.handler.codec.MessageToMessageDecoder;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DatagramDnsQuery;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsOpCode;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsQuery;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsRecord;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsRecordDecoder;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsSection;
import io.mantisrx.shaded.io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;
import java.util.List;

@ChannelHandler.Sharable
public class DatagramDnsQueryDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private final DnsRecordDecoder recordDecoder;

    public DatagramDnsQueryDecoder() {
        this(DnsRecordDecoder.DEFAULT);
    }

    public DatagramDnsQueryDecoder(DnsRecordDecoder recordDecoder) {
        this.recordDecoder = ObjectUtil.checkNotNull(recordDecoder, "recordDecoder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, DatagramPacket packet, List<Object> out) throws Exception {
        ByteBuf buf = (ByteBuf)packet.content();
        DnsQuery query2 = DatagramDnsQueryDecoder.newQuery(packet, buf);
        boolean success2 = false;
        try {
            int questionCount = buf.readUnsignedShort();
            int answerCount = buf.readUnsignedShort();
            int authorityRecordCount = buf.readUnsignedShort();
            int additionalRecordCount = buf.readUnsignedShort();
            this.decodeQuestions(query2, buf, questionCount);
            this.decodeRecords(query2, DnsSection.ANSWER, buf, answerCount);
            this.decodeRecords(query2, DnsSection.AUTHORITY, buf, authorityRecordCount);
            this.decodeRecords(query2, DnsSection.ADDITIONAL, buf, additionalRecordCount);
            out.add(query2);
            success2 = true;
        }
        finally {
            if (!success2) {
                query2.release();
            }
        }
    }

    private static DnsQuery newQuery(DatagramPacket packet, ByteBuf buf) {
        int id = buf.readUnsignedShort();
        int flags = buf.readUnsignedShort();
        if (flags >> 15 == 1) {
            throw new CorruptedFrameException("not a query");
        }
        DatagramDnsQuery query2 = new DatagramDnsQuery((InetSocketAddress)packet.sender(), (InetSocketAddress)packet.recipient(), id, DnsOpCode.valueOf((byte)(flags >> 11 & 0xF)));
        query2.setRecursionDesired((flags >> 8 & 1) == 1);
        query2.setZ(flags >> 4 & 7);
        return query2;
    }

    private void decodeQuestions(DnsQuery query2, ByteBuf buf, int questionCount) throws Exception {
        for (int i = questionCount; i > 0; --i) {
            query2.addRecord(DnsSection.QUESTION, this.recordDecoder.decodeQuestion(buf));
        }
    }

    private void decodeRecords(DnsQuery query2, DnsSection section, ByteBuf buf, int count2) throws Exception {
        Object r;
        for (int i = count2; i > 0 && (r = this.recordDecoder.decodeRecord(buf)) != null; --i) {
            query2.addRecord(section, (DnsRecord)r);
        }
    }
}

