/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.netty.resolver.dns;

import io.mantisrx.shaded.io.netty.channel.AddressedEnvelope;
import io.mantisrx.shaded.io.netty.channel.Channel;
import io.mantisrx.shaded.io.netty.channel.ChannelFuture;
import io.mantisrx.shaded.io.netty.channel.ChannelFutureListener;
import io.mantisrx.shaded.io.netty.channel.ChannelPromise;
import io.mantisrx.shaded.io.netty.handler.codec.dns.AbstractDnsOptPseudoRrRecord;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DatagramDnsQuery;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsQuery;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsQuestion;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsRecord;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsResponse;
import io.mantisrx.shaded.io.netty.handler.codec.dns.DnsSection;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsNameResolver;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsNameResolverException;
import io.mantisrx.shaded.io.netty.resolver.dns.DnsNameResolverTimeoutException;
import io.mantisrx.shaded.io.netty.util.concurrent.Future;
import io.mantisrx.shaded.io.netty.util.concurrent.FutureListener;
import io.mantisrx.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.mantisrx.shaded.io.netty.util.concurrent.Promise;
import io.mantisrx.shaded.io.netty.util.concurrent.ScheduledFuture;
import io.mantisrx.shaded.io.netty.util.internal.ObjectUtil;
import io.mantisrx.shaded.io.netty.util.internal.logging.InternalLogger;
import io.mantisrx.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;

final class DnsQueryContext
implements FutureListener<AddressedEnvelope<DnsResponse, InetSocketAddress>> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DnsQueryContext.class);
    private final DnsNameResolver parent;
    private final Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise;
    private final int id;
    private final DnsQuestion question;
    private final DnsRecord[] additionals;
    private final DnsRecord optResource;
    private final InetSocketAddress nameServerAddr;
    private final boolean recursionDesired;
    private volatile ScheduledFuture<?> timeoutFuture;

    DnsQueryContext(DnsNameResolver parent, InetSocketAddress nameServerAddr, DnsQuestion question, DnsRecord[] additionals, Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise2) {
        this.parent = ObjectUtil.checkNotNull(parent, "parent");
        this.nameServerAddr = ObjectUtil.checkNotNull(nameServerAddr, "nameServerAddr");
        this.question = ObjectUtil.checkNotNull(question, "question");
        this.additionals = ObjectUtil.checkNotNull(additionals, "additionals");
        this.promise = ObjectUtil.checkNotNull(promise2, "promise");
        this.recursionDesired = parent.isRecursionDesired();
        this.id = parent.queryContextManager.add(this);
        promise2.addListener(this);
        this.optResource = parent.isOptResourceEnabled() ? new AbstractDnsOptPseudoRrRecord(parent.maxPayloadSize(), 0, 0){} : null;
    }

    InetSocketAddress nameServerAddr() {
        return this.nameServerAddr;
    }

    DnsQuestion question() {
        return this.question;
    }

    void query(boolean flush2, ChannelPromise writePromise) {
        DnsQuestion question = this.question();
        InetSocketAddress nameServerAddr = this.nameServerAddr();
        DatagramDnsQuery query2 = new DatagramDnsQuery(null, nameServerAddr, this.id);
        query2.setRecursionDesired(this.recursionDesired);
        query2.addRecord(DnsSection.QUESTION, question);
        for (DnsRecord record : this.additionals) {
            query2.addRecord(DnsSection.ADDITIONAL, record);
        }
        if (this.optResource != null) {
            query2.addRecord(DnsSection.ADDITIONAL, this.optResource);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} WRITE: [{}: {}], {}", this.parent.ch, this.id, nameServerAddr, question);
        }
        this.sendQuery(query2, flush2, writePromise);
    }

    private void sendQuery(final DnsQuery query2, boolean flush2, final ChannelPromise writePromise) {
        if (this.parent.channelFuture.isDone()) {
            this.writeQuery(query2, flush2, writePromise);
        } else {
            this.parent.channelFuture.addListener((GenericFutureListener<Future<Channel>>)new GenericFutureListener<Future<? super Channel>>(){

                @Override
                public void operationComplete(Future<? super Channel> future2) {
                    if (future2.isSuccess()) {
                        DnsQueryContext.this.writeQuery(query2, true, writePromise);
                    } else {
                        Throwable cause = future2.cause();
                        DnsQueryContext.this.promise.tryFailure(cause);
                        writePromise.setFailure(cause);
                    }
                }
            });
        }
    }

    private void writeQuery(DnsQuery query2, boolean flush2, ChannelPromise writePromise) {
        ChannelFuture writeFuture;
        ChannelFuture channelFuture = writeFuture = flush2 ? this.parent.ch.writeAndFlush(query2, writePromise) : this.parent.ch.write(query2, writePromise);
        if (writeFuture.isDone()) {
            this.onQueryWriteCompletion(writeFuture);
        } else {
            writeFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future2) {
                    DnsQueryContext.this.onQueryWriteCompletion(writeFuture);
                }
            });
        }
    }

    private void onQueryWriteCompletion(ChannelFuture writeFuture) {
        if (!writeFuture.isSuccess()) {
            this.setFailure("failed to send a query", writeFuture.cause());
            return;
        }
        final long queryTimeoutMillis = this.parent.queryTimeoutMillis();
        if (queryTimeoutMillis > 0L) {
            this.timeoutFuture = this.parent.ch.eventLoop().schedule(new Runnable(){

                @Override
                public void run() {
                    if (DnsQueryContext.this.promise.isDone()) {
                        return;
                    }
                    DnsQueryContext.this.setFailure("query timed out after " + queryTimeoutMillis + " milliseconds", null);
                }
            }, queryTimeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    void finish(AddressedEnvelope<? extends DnsResponse, InetSocketAddress> envelope) {
        DnsResponse res = envelope.content();
        if (res.count(DnsSection.QUESTION) != 1) {
            logger.warn("Received a DNS response with invalid number of questions: {}", (Object)envelope);
            return;
        }
        if (!this.question().equals(res.recordAt(DnsSection.QUESTION))) {
            logger.warn("Received a mismatching DNS response: {}", (Object)envelope);
            return;
        }
        this.setSuccess(envelope);
    }

    private void setSuccess(AddressedEnvelope<? extends DnsResponse, InetSocketAddress> envelope) {
        Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise2 = this.promise;
        AddressedEnvelope<? extends DnsResponse, InetSocketAddress> castResponse = envelope.retain();
        if (!promise2.trySuccess(castResponse)) {
            envelope.release();
        }
    }

    private void setFailure(String message, Throwable cause) {
        InetSocketAddress nameServerAddr = this.nameServerAddr();
        StringBuilder buf = new StringBuilder(message.length() + 64);
        buf.append('[').append(nameServerAddr).append("] ").append(message).append(" (no stack trace available)");
        DnsNameResolverException e2 = cause == null ? new DnsNameResolverTimeoutException(nameServerAddr, this.question(), buf.toString()) : new DnsNameResolverException(nameServerAddr, this.question(), buf.toString(), cause);
        this.promise.tryFailure(e2);
    }

    @Override
    public void operationComplete(Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> future2) {
        ScheduledFuture<?> timeoutFuture = this.timeoutFuture;
        if (timeoutFuture != null) {
            this.timeoutFuture = null;
            timeoutFuture.cancel(false);
        }
        this.parent.queryContextManager.remove(this.nameServerAddr, this.id);
    }
}

