/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize;

import io.mantisrx.shaded.com.fasterxml.jackson.databind.BeanDescription;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JavaType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.KeyDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.deser.Deserializers;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.CollectionLikeType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.MapLikeType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.ReferenceType;
import io.mantisrx.shaded.io.vavr.jackson.datatype.VavrModule;
import io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize.CharSeqDeserializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize.EitherDeserializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize.LazyDeserializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize.MapDeserializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize.MultimapDeserializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize.OptionDeserializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize.PriorityQueueDeserializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize.SeqDeserializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize.SerializableDeserializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize.SetDeserializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize.TupleDeserializer;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedFunction2;
import io.vavr.CheckedFunction3;
import io.vavr.CheckedFunction4;
import io.vavr.CheckedFunction5;
import io.vavr.CheckedFunction6;
import io.vavr.CheckedFunction7;
import io.vavr.CheckedFunction8;
import io.vavr.Function0;
import io.vavr.Function1;
import io.vavr.Function2;
import io.vavr.Function3;
import io.vavr.Function4;
import io.vavr.Function5;
import io.vavr.Function6;
import io.vavr.Function7;
import io.vavr.Function8;
import io.vavr.Lazy;
import io.vavr.Tuple;
import io.vavr.collection.CharSeq;
import io.vavr.collection.Map;
import io.vavr.collection.Multimap;
import io.vavr.collection.PriorityQueue;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.control.Either;
import io.vavr.control.Option;

public class VavrDeserializers
extends Deserializers.Base {
    private final VavrModule.Settings settings;

    public VavrDeserializers(VavrModule.Settings settings) {
        this.settings = settings;
    }

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType type2, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> raw = type2.getRawClass();
        if (Either.class.isAssignableFrom(raw)) {
            return new EitherDeserializer(type2);
        }
        if (Tuple.class.isAssignableFrom(raw)) {
            return new TupleDeserializer(type2);
        }
        if (Function0.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type2);
        }
        if (Function1.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type2);
        }
        if (Function2.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type2);
        }
        if (Function3.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type2);
        }
        if (Function4.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type2);
        }
        if (Function5.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type2);
        }
        if (Function6.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type2);
        }
        if (Function7.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type2);
        }
        if (Function8.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type2);
        }
        if (CheckedFunction0.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type2);
        }
        if (CheckedFunction1.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type2);
        }
        if (CheckedFunction2.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type2);
        }
        if (CheckedFunction3.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type2);
        }
        if (CheckedFunction4.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type2);
        }
        if (CheckedFunction5.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type2);
        }
        if (CheckedFunction6.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type2);
        }
        if (CheckedFunction7.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type2);
        }
        if (CheckedFunction8.class.isAssignableFrom(raw)) {
            return new SerializableDeserializer(type2);
        }
        return super.findBeanDeserializer(type2, config, beanDesc);
    }

    @Override
    public JsonDeserializer<?> findReferenceDeserializer(ReferenceType type2, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer contentTypeDeserializer, JsonDeserializer<?> contentDeserializer) throws JsonMappingException {
        Class<?> raw = type2.getRawClass();
        if (raw == Lazy.class) {
            return new LazyDeserializer(type2);
        }
        if (raw == Option.class) {
            return new OptionDeserializer((JavaType)type2, this.settings.useOptionInPlainFormat());
        }
        return super.findReferenceDeserializer(type2, config, beanDesc, contentTypeDeserializer, contentDeserializer);
    }

    @Override
    public JsonDeserializer<?> findCollectionLikeDeserializer(CollectionLikeType type2, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class<?> raw = type2.getRawClass();
        if (raw == CharSeq.class) {
            return new CharSeqDeserializer(type2);
        }
        if (Seq.class.isAssignableFrom(raw)) {
            return new SeqDeserializer((JavaType)type2, this.settings.deserializeNullAsEmptyCollection());
        }
        if (Set.class.isAssignableFrom(raw)) {
            return new SetDeserializer((JavaType)type2, this.settings.deserializeNullAsEmptyCollection());
        }
        if (PriorityQueue.class.isAssignableFrom(raw)) {
            return new PriorityQueueDeserializer((JavaType)type2, this.settings.deserializeNullAsEmptyCollection());
        }
        return super.findCollectionLikeDeserializer(type2, config, beanDesc, elementTypeDeserializer, elementDeserializer);
    }

    @Override
    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType type2, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class<?> raw = type2.getRawClass();
        if (Map.class.isAssignableFrom(raw)) {
            return new MapDeserializer(type2);
        }
        if (Multimap.class.isAssignableFrom(raw)) {
            return new MultimapDeserializer(type2);
        }
        return super.findMapLikeDeserializer(type2, config, beanDesc, keyDeserializer, elementTypeDeserializer, elementDeserializer);
    }
}

