/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.api.transaction;

import io.mantisrx.shaded.org.apache.curator.framework.api.transaction.OperationType;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Predicate;
import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;

public class CuratorTransactionResult {
    private final OperationType type;
    private final String forPath;
    private final String resultPath;
    private final Stat resultStat;
    private final int error;

    public static Predicate<CuratorTransactionResult> ofTypeAndPath(final OperationType type2, final String forPath) {
        return new Predicate<CuratorTransactionResult>(){

            @Override
            public boolean apply(CuratorTransactionResult result) {
                return result.getType() == type2 && result.getForPath().equals(forPath);
            }
        };
    }

    public CuratorTransactionResult(OperationType type2, String forPath, String resultPath, Stat resultStat) {
        this(type2, forPath, resultPath, resultStat, 0);
    }

    public CuratorTransactionResult(OperationType type2, String forPath, String resultPath, Stat resultStat, int error) {
        this.forPath = forPath;
        this.resultPath = resultPath;
        this.resultStat = resultStat;
        this.type = type2;
        this.error = error;
    }

    public OperationType getType() {
        return this.type;
    }

    public String getForPath() {
        return this.forPath;
    }

    public String getResultPath() {
        return this.resultPath;
    }

    public Stat getResultStat() {
        return this.resultStat;
    }

    public int getError() {
        return this.error;
    }
}

