/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.recipes.locks;

import io.mantisrx.shaded.org.apache.curator.framework.CuratorFramework;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.locks.Lease;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.locks.LockInternals;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.locks.StandardLockInternalsDriver;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.shared.SharedCountListener;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.shared.SharedCountReader;
import io.mantisrx.shaded.org.apache.curator.framework.state.ConnectionState;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import io.mantisrx.shaded.org.apache.curator.utils.CloseableUtils;
import io.mantisrx.shaded.org.apache.curator.utils.ThreadUtils;
import io.mantisrx.shaded.org.apache.curator.utils.ZKPaths;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class InterProcessSemaphore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final LockInternals internals;
    private static final String LOCK_NAME = "lock-";

    public InterProcessSemaphore(CuratorFramework client, String path2, int maxLeases) {
        this(client, path2, maxLeases, null);
    }

    public InterProcessSemaphore(CuratorFramework client, String path2, SharedCountReader count2) {
        this(client, path2, 0, count2);
    }

    private InterProcessSemaphore(CuratorFramework client, String path2, int maxLeases, SharedCountReader count2) {
        this.internals = new LockInternals(client, new StandardLockInternalsDriver(), path2, LOCK_NAME, count2 != null ? count2.getCount() : maxLeases);
        if (count2 != null) {
            count2.addListener(new SharedCountListener(){

                @Override
                public void countHasChanged(SharedCountReader sharedCount, int newCount) throws Exception {
                    InterProcessSemaphore.this.internals.setMaxLeases(newCount);
                }

                @Override
                public void stateChanged(CuratorFramework client, ConnectionState newState) {
                }
            });
        }
    }

    public void returnAll(Collection<Lease> leases) {
        for (Lease l : leases) {
            CloseableUtils.closeQuietly(l);
        }
    }

    public void returnLease(Lease lease) {
        CloseableUtils.closeQuietly(lease);
    }

    public Lease acquire() throws Exception {
        String path2 = this.internals.attemptLock(-1L, null, null);
        return this.makeLease(path2);
    }

    public Collection<Lease> acquire(int qty) throws Exception {
        Preconditions.checkArgument(qty > 0, "qty cannot be 0");
        ImmutableList.Builder builder = ImmutableList.builder();
        try {
            while (qty-- > 0) {
                String path2 = this.internals.attemptLock(-1L, null, null);
                builder.add(this.makeLease(path2));
            }
        }
        catch (Exception e2) {
            ThreadUtils.checkInterrupted(e2);
            this.returnAll(builder.build());
            throw e2;
        }
        return builder.build();
    }

    public Lease acquire(long time2, TimeUnit unit) throws Exception {
        String path2 = this.internals.attemptLock(time2, unit, null);
        return path2 != null ? this.makeLease(path2) : null;
    }

    public Collection<Lease> acquire(int qty, long time2, TimeUnit unit) throws Exception {
        long startMs = System.currentTimeMillis();
        long waitMs = TimeUnit.MILLISECONDS.convert(time2, unit);
        Preconditions.checkArgument(qty > 0, "qty cannot be 0");
        ImmutableList.Builder builder = ImmutableList.builder();
        try {
            while (qty-- > 0) {
                String path2;
                long elapsedMs = System.currentTimeMillis() - startMs;
                long thisWaitMs = waitMs - elapsedMs;
                String string2 = path2 = thisWaitMs > 0L ? this.internals.attemptLock(thisWaitMs, TimeUnit.MILLISECONDS, null) : null;
                if (path2 == null) {
                    this.returnAll(builder.build());
                    return null;
                }
                builder.add(this.makeLease(path2));
            }
        }
        catch (Exception e2) {
            ThreadUtils.checkInterrupted(e2);
            this.returnAll(builder.build());
            throw e2;
        }
        return builder.build();
    }

    private Lease makeLease(final String path2) {
        return new Lease(){

            @Override
            public void close() throws IOException {
                try {
                    InterProcessSemaphore.this.internals.releaseLock(path2);
                }
                catch (KeeperException.NoNodeException e2) {
                    InterProcessSemaphore.this.log.warn("Lease already released", e2);
                }
                catch (Exception e3) {
                    ThreadUtils.checkInterrupted(e3);
                    throw new IOException(e3);
                }
            }

            @Override
            public byte[] getData() throws Exception {
                return (byte[])InterProcessSemaphore.this.internals.getClient().getData().forPath(path2);
            }

            @Override
            public String getNodeName() {
                return ZKPaths.getNodeFromPath(path2);
            }
        };
    }
}

