/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.recipes.queue;

import io.mantisrx.shaded.org.apache.curator.framework.CuratorFramework;
import io.mantisrx.shaded.org.apache.curator.framework.EnsureContainers;
import io.mantisrx.shaded.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.api.BackgroundPathable;
import io.mantisrx.shaded.org.apache.curator.utils.PathUtils;
import io.mantisrx.shaded.org.apache.curator.utils.ZKPaths;
import io.mantisrx.shaded.org.apache.zookeeper.CreateMode;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.WatchedEvent;
import io.mantisrx.shaded.org.apache.zookeeper.Watcher;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDistributedQueue {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final String path;
    private final EnsureContainers ensureContainers;
    private final String PREFIX = "qn-";

    public SimpleDistributedQueue(CuratorFramework client, String path2) {
        this.client = client;
        this.path = PathUtils.validatePath(path2);
        this.ensureContainers = new EnsureContainers(client, path2);
    }

    public byte[] element() throws Exception {
        byte[] bytes2 = this.internalElement(false, null);
        if (bytes2 == null) {
            throw new NoSuchElementException();
        }
        return bytes2;
    }

    public byte[] remove() throws Exception {
        byte[] bytes2 = this.internalElement(true, null);
        if (bytes2 == null) {
            throw new NoSuchElementException();
        }
        return bytes2;
    }

    public byte[] take() throws Exception {
        return this.internalPoll(0L, null);
    }

    public boolean offer(byte[] data2) throws Exception {
        String thisPath = ZKPaths.makePath(this.path, "qn-");
        ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentContainersIfNeeded().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(thisPath, data2);
        return true;
    }

    public byte[] peek() throws Exception {
        try {
            return this.element();
        }
        catch (NoSuchElementException e2) {
            return null;
        }
    }

    public byte[] poll(long timeout, TimeUnit unit) throws Exception {
        return this.internalPoll(timeout, unit);
    }

    public byte[] poll() throws Exception {
        try {
            return this.remove();
        }
        catch (NoSuchElementException e2) {
            return null;
        }
    }

    protected void ensurePath() throws Exception {
        this.ensureContainers.ensure();
    }

    private byte[] internalPoll(long timeout, TimeUnit unit) throws Exception {
        this.ensurePath();
        long startMs = System.currentTimeMillis();
        boolean hasTimeout = unit != null;
        long maxWaitMs = hasTimeout ? TimeUnit.MILLISECONDS.convert(timeout, unit) : Long.MAX_VALUE;
        while (true) {
            byte[] bytes2;
            final CountDownLatch latch = new CountDownLatch(1);
            Watcher watcher = new Watcher(){

                @Override
                public void process(WatchedEvent event) {
                    latch.countDown();
                }
            };
            try {
                bytes2 = this.internalElement(true, watcher);
            }
            catch (NoSuchElementException dummy) {
                this.log.debug("Parent containers appear to have lapsed - recreate and retry");
                this.ensureContainers.reset();
                continue;
            }
            if (bytes2 != null) {
                return bytes2;
            }
            if (hasTimeout) {
                long elapsedMs = System.currentTimeMillis() - startMs;
                long thisWaitMs = maxWaitMs - elapsedMs;
                if (thisWaitMs <= 0L) {
                    return null;
                }
                latch.await(thisWaitMs, TimeUnit.MILLISECONDS);
                continue;
            }
            latch.await();
        }
    }

    private byte[] internalElement(boolean removeIt, Watcher watcher) throws Exception {
        List nodes;
        this.ensurePath();
        try {
            nodes = watcher != null ? (List)((BackgroundPathable)this.client.getChildren().usingWatcher(watcher)).forPath(this.path) : (List)this.client.getChildren().forPath(this.path);
        }
        catch (KeeperException.NoNodeException dummy) {
            throw new NoSuchElementException();
        }
        Collections.sort(nodes);
        for (String node2 : nodes) {
            if (!node2.startsWith("qn-")) {
                this.log.warn("Foreign node in queue path: " + node2);
                continue;
            }
            String thisPath = ZKPaths.makePath(this.path, node2);
            try {
                byte[] bytes2 = (byte[])this.client.getData().forPath(thisPath);
                if (removeIt) {
                    this.client.delete().forPath(thisPath);
                }
                return bytes2;
            }
            catch (KeeperException.NoNodeException noNodeException) {
            }
        }
        return null;
    }
}

