/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.recipes.watch;

import io.mantisrx.shaded.org.apache.curator.framework.CuratorFramework;
import io.mantisrx.shaded.org.apache.curator.framework.api.BackgroundCallback;
import io.mantisrx.shaded.org.apache.curator.framework.api.BackgroundPathableQuietlyable;
import io.mantisrx.shaded.org.apache.curator.framework.api.ErrorListenerPathable;
import io.mantisrx.shaded.org.apache.curator.framework.api.Pathable;
import io.mantisrx.shaded.org.apache.curator.framework.api.WatchableBase;
import io.mantisrx.shaded.org.apache.curator.framework.listen.Listenable;
import io.mantisrx.shaded.org.apache.curator.framework.listen.StandardListenerManager;
import io.mantisrx.shaded.org.apache.curator.framework.state.ConnectionStateListener;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.org.apache.curator.utils.ThreadUtils;
import io.mantisrx.shaded.org.apache.zookeeper.AddWatchMode;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.Watcher;
import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentWatcher
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final StandardListenerManager<Watcher> listeners = StandardListenerManager.standard();
    private final StandardListenerManager<Runnable> resetListeners = StandardListenerManager.standard();
    private final ConnectionStateListener connectionStateListener = (client, newState) -> {
        if (newState.isConnected()) {
            this.reset();
        }
    };
    private final Watcher watcher = event -> this.listeners.forEach(w -> w.process(event));
    private final CuratorFramework client;
    private final String basePath;
    private final boolean recursive;

    public PersistentWatcher(CuratorFramework client2, String basePath, boolean recursive) {
        this.client = Objects.requireNonNull(client2, "client cannot be null");
        this.basePath = Objects.requireNonNull(basePath, "basePath cannot be null");
        this.recursive = recursive;
    }

    public void start() {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "Already started");
        this.client.getConnectionStateListenable().addListener(this.connectionStateListener);
        this.reset();
    }

    @Override
    public void close() {
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            this.listeners.clear();
            this.client.getConnectionStateListenable().removeListener(this.connectionStateListener);
            try {
                ((ErrorListenerPathable)((BackgroundPathableQuietlyable)this.client.watchers().remove(this.watcher).guaranteed()).inBackground()).forPath(this.basePath);
            }
            catch (Exception e2) {
                ThreadUtils.checkInterrupted(e2);
                this.log.debug(String.format("Could not remove watcher for path: %s", this.basePath), e2);
            }
        }
    }

    public Listenable<Watcher> getListenable() {
        return this.listeners;
    }

    public Listenable<Runnable> getResetListenable() {
        return this.resetListeners;
    }

    private void reset() {
        if (this.state.get() != State.STARTED) {
            return;
        }
        try {
            BackgroundCallback callback = (__, event) -> {
                if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                    this.resetListeners.forEach(Runnable::run);
                } else {
                    this.reset();
                }
            };
            ((Pathable)((WatchableBase)this.client.watchers().add().withMode(this.recursive ? AddWatchMode.PERSISTENT_RECURSIVE : AddWatchMode.PERSISTENT).inBackground(callback)).usingWatcher(this.watcher)).forPath(this.basePath);
        }
        catch (Exception e2) {
            this.log.error("Could not reset persistent watch at path: " + this.basePath, e2);
        }
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

