/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph;

import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.annotations.Beta;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Function;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableMap;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.Maps;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.ConfigurableValueGraph;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.DirectedGraphConnections;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.GraphConnections;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.ImmutableGraph;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.UndirectedGraphConnections;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.ValueGraph;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.graph.ValueGraphBuilder;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.errorprone.annotations.Immutable;

@Immutable(containerOf={"N", "V"})
@Beta
public final class ImmutableValueGraph<N, V>
extends ConfigurableValueGraph<N, V> {
    private ImmutableValueGraph(ValueGraph<N, V> graph2) {
        super(ValueGraphBuilder.from(graph2), ImmutableValueGraph.getNodeConnections(graph2), graph2.edges().size());
    }

    public static <N, V> ImmutableValueGraph<N, V> copyOf(ValueGraph<N, V> graph2) {
        return graph2 instanceof ImmutableValueGraph ? (ImmutableValueGraph<N, V>)graph2 : new ImmutableValueGraph<N, V>(graph2);
    }

    @Deprecated
    public static <N, V> ImmutableValueGraph<N, V> copyOf(ImmutableValueGraph<N, V> graph2) {
        return Preconditions.checkNotNull(graph2);
    }

    @Override
    public ImmutableGraph<N> asGraph() {
        return new ImmutableGraph(this);
    }

    private static <N, V> ImmutableMap<N, GraphConnections<N, V>> getNodeConnections(ValueGraph<N, V> graph2) {
        ImmutableMap.Builder<N, GraphConnections<N, V>> nodeConnections = ImmutableMap.builder();
        for (N node2 : graph2.nodes()) {
            nodeConnections.put(node2, ImmutableValueGraph.connectionsOf(graph2, node2));
        }
        return nodeConnections.build();
    }

    private static <N, V> GraphConnections<N, V> connectionsOf(final ValueGraph<N, V> graph2, final N node2) {
        Function successorNodeToValueFn = new Function<N, V>(){

            @Override
            public V apply(N successorNode) {
                return graph2.edgeValueOrDefault(node2, successorNode, null);
            }
        };
        return graph2.isDirected() ? DirectedGraphConnections.ofImmutable(graph2.predecessors((Object)node2), Maps.asMap(graph2.successors((Object)node2), successorNodeToValueFn)) : UndirectedGraphConnections.ofImmutable(Maps.asMap(graph2.adjacentNodes(node2), successorNodeToValueFn));
    }
}

