/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.utils;

import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compatibility {
    private static final Logger log;
    private static final Method getReachableOrOneMethod;
    private static final Field addrField;
    private static final boolean hasPersistentWatchers;

    public static boolean hasGetReachableOrOneMethod() {
        return getReachableOrOneMethod != null;
    }

    public static boolean hasAddrField() {
        return addrField != null;
    }

    public static String getHostAddress(QuorumPeer.QuorumServer server2) {
        InetSocketAddress address = null;
        if (getReachableOrOneMethod != null) {
            try {
                address = (InetSocketAddress)getReachableOrOneMethod.invoke((Object)server2.addr, new Object[0]);
            }
            catch (Exception e2) {
                log.error("Could not call getReachableOrOneMethod.invoke({})", (Object)server2.addr, (Object)e2);
            }
        } else if (addrField != null) {
            try {
                address = (InetSocketAddress)addrField.get(server2);
            }
            catch (Exception e3) {
                log.error("Could not call addrField.get({})", (Object)server2, (Object)e3);
            }
        }
        return address != null ? address.getAddress().getHostAddress() : "unknown";
    }

    public static boolean hasPersistentWatchers() {
        return hasPersistentWatchers;
    }

    static {
        boolean localHasPersistentWatchers;
        Field localAddrField;
        Method localGetReachableOrOneMethod;
        log = LoggerFactory.getLogger(Compatibility.class);
        try {
            Class<?> multipleAddressesClass = Class.forName("io.mantisrx.shaded.org.apache.zookeeper.server.quorum.MultipleAddresses");
            localGetReachableOrOneMethod = multipleAddressesClass.getMethod("getReachableOrOne", new Class[0]);
            log.info("Using org.apache.zookeeper.server.quorum.MultipleAddresses");
        }
        catch (ReflectiveOperationException ignore) {
            localGetReachableOrOneMethod = null;
        }
        getReachableOrOneMethod = localGetReachableOrOneMethod;
        try {
            localAddrField = QuorumPeer.QuorumServer.class.getField("addr");
        }
        catch (NoSuchFieldException e2) {
            localAddrField = null;
            log.error("Could not get addr field! Reconfiguration fail!");
        }
        addrField = localAddrField;
        try {
            Class.forName("io.mantisrx.shaded.org.apache.zookeeper.AddWatchMode");
            localHasPersistentWatchers = true;
        }
        catch (ClassNotFoundException e3) {
            localHasPersistentWatchers = false;
            log.info("Persistent Watchers are not available in the version of the ZooKeeper library being used");
        }
        hasPersistentWatchers = localHasPersistentWatchers;
    }
}

