/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.metrics.impl;

import io.mantisrx.shaded.org.apache.zookeeper.metrics.Counter;
import io.mantisrx.shaded.org.apache.zookeeper.metrics.Gauge;
import io.mantisrx.shaded.org.apache.zookeeper.metrics.MetricsContext;
import io.mantisrx.shaded.org.apache.zookeeper.metrics.MetricsProvider;
import io.mantisrx.shaded.org.apache.zookeeper.metrics.MetricsProviderLifeCycleException;
import io.mantisrx.shaded.org.apache.zookeeper.metrics.Summary;
import io.mantisrx.shaded.org.apache.zookeeper.metrics.SummarySet;
import io.mantisrx.shaded.org.apache.zookeeper.server.metric.AvgMinMaxCounter;
import io.mantisrx.shaded.org.apache.zookeeper.server.metric.AvgMinMaxCounterSet;
import io.mantisrx.shaded.org.apache.zookeeper.server.metric.AvgMinMaxPercentileCounter;
import io.mantisrx.shaded.org.apache.zookeeper.server.metric.AvgMinMaxPercentileCounterSet;
import io.mantisrx.shaded.org.apache.zookeeper.server.metric.SimpleCounter;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;

public class DefaultMetricsProvider
implements MetricsProvider {
    private final DefaultMetricsContext rootMetricsContext = new DefaultMetricsContext();

    @Override
    public void configure(Properties configuration) throws MetricsProviderLifeCycleException {
    }

    @Override
    public void start() throws MetricsProviderLifeCycleException {
    }

    @Override
    public MetricsContext getRootContext() {
        return this.rootMetricsContext;
    }

    @Override
    public void stop() {
        this.rootMetricsContext.gauges.clear();
    }

    @Override
    public void dump(BiConsumer<String, Object> sink) {
        this.rootMetricsContext.dump(sink);
    }

    @Override
    public void resetAllValues() {
        this.rootMetricsContext.reset();
    }

    private static final class DefaultMetricsContext
    implements MetricsContext {
        private final ConcurrentMap<String, Gauge> gauges = new ConcurrentHashMap<String, Gauge>();
        private final ConcurrentMap<String, SimpleCounter> counters = new ConcurrentHashMap<String, SimpleCounter>();
        private final ConcurrentMap<String, AvgMinMaxCounter> basicSummaries = new ConcurrentHashMap<String, AvgMinMaxCounter>();
        private final ConcurrentMap<String, AvgMinMaxPercentileCounter> summaries = new ConcurrentHashMap<String, AvgMinMaxPercentileCounter>();
        private final ConcurrentMap<String, AvgMinMaxCounterSet> basicSummarySets = new ConcurrentHashMap<String, AvgMinMaxCounterSet>();
        private final ConcurrentMap<String, AvgMinMaxPercentileCounterSet> summarySets = new ConcurrentHashMap<String, AvgMinMaxPercentileCounterSet>();

        private DefaultMetricsContext() {
        }

        @Override
        public MetricsContext getContext(String name2) {
            return this;
        }

        @Override
        public Counter getCounter(String name2) {
            return this.counters.computeIfAbsent(name2, n -> new SimpleCounter((String)n));
        }

        @Override
        public void registerGauge(String name2, Gauge gauge) {
            Objects.requireNonNull(gauge, "Cannot register a null Gauge for " + name2);
            this.gauges.put(name2, gauge);
        }

        @Override
        public void unregisterGauge(String name2) {
            this.gauges.remove(name2);
        }

        @Override
        public Summary getSummary(String name2, MetricsContext.DetailLevel detailLevel) {
            if (detailLevel == MetricsContext.DetailLevel.BASIC) {
                return this.basicSummaries.computeIfAbsent(name2, n -> {
                    if (this.summaries.containsKey(n)) {
                        throw new IllegalArgumentException("Already registered a non basic summary as " + n);
                    }
                    return new AvgMinMaxCounter(name2);
                });
            }
            return this.summaries.computeIfAbsent(name2, n -> {
                if (this.basicSummaries.containsKey(n)) {
                    throw new IllegalArgumentException("Already registered a basic summary as " + n);
                }
                return new AvgMinMaxPercentileCounter(name2);
            });
        }

        @Override
        public SummarySet getSummarySet(String name2, MetricsContext.DetailLevel detailLevel) {
            if (detailLevel == MetricsContext.DetailLevel.BASIC) {
                return this.basicSummarySets.computeIfAbsent(name2, n -> {
                    if (this.summarySets.containsKey(n)) {
                        throw new IllegalArgumentException("Already registered a non basic summary set as " + n);
                    }
                    return new AvgMinMaxCounterSet(name2);
                });
            }
            return this.summarySets.computeIfAbsent(name2, n -> {
                if (this.basicSummarySets.containsKey(n)) {
                    throw new IllegalArgumentException("Already registered a basic summary set as " + n);
                }
                return new AvgMinMaxPercentileCounterSet(name2);
            });
        }

        void dump(BiConsumer<String, Object> sink) {
            this.gauges.forEach((name2, metric) -> {
                Number value = metric.get();
                if (value != null) {
                    sink.accept((String)name2, value);
                }
            });
            this.counters.values().forEach(metric -> metric.values().forEach(sink));
            this.basicSummaries.values().forEach(metric -> metric.values().forEach(sink));
            this.summaries.values().forEach(metric -> metric.values().forEach(sink));
            this.basicSummarySets.values().forEach(metric -> metric.values().forEach(sink));
            this.summarySets.values().forEach(metric -> metric.values().forEach(sink));
        }

        void reset() {
            this.counters.values().forEach(metric -> metric.reset());
            this.basicSummaries.values().forEach(metric -> metric.reset());
            this.summaries.values().forEach(metric -> metric.reset());
            this.basicSummarySets.values().forEach(metric -> metric.reset());
            this.summarySets.values().forEach(metric -> metric.reset());
        }
    }
}

