/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server;

import io.mantisrx.shaded.org.apache.zookeeper.data.StatPersisted;
import io.mantisrx.shaded.org.apache.zookeeper.server.DataNode;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;

public class DigestCalculator {
    private static final int DIGEST_VERSION = 2;

    long calculateDigest(String path2, byte[] data2, StatPersisted stat) {
        if (!ZooKeeperServer.isDigestEnabled()) {
            return 0L;
        }
        if (path2.startsWith("/zookeeper/")) {
            return 0L;
        }
        if (path2.equals("/")) {
            path2 = "";
        }
        byte[] b = new byte[60];
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.putLong(stat.getCzxid());
        bb.putLong(stat.getMzxid());
        bb.putLong(stat.getPzxid());
        bb.putLong(stat.getCtime());
        bb.putLong(stat.getMtime());
        bb.putInt(stat.getVersion());
        bb.putInt(stat.getCversion());
        bb.putInt(stat.getAversion());
        bb.putLong(stat.getEphemeralOwner());
        CRC32 crc = new CRC32();
        crc.update(path2.getBytes());
        if (data2 != null) {
            crc.update(data2);
        }
        crc.update(b);
        return crc.getValue();
    }

    long calculateDigest(String path2, DataNode node2) {
        if (!node2.isDigestCached()) {
            node2.setDigest(this.calculateDigest(path2, node2.getData(), node2.stat));
            node2.setDigestCached(true);
        }
        return node2.getDigest();
    }

    int getDigestVersion() {
        return 2;
    }
}

