/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server;

import io.mantisrx.shaded.org.apache.zookeeper.common.Time;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class ExpiryQueue<E> {
    private final ConcurrentHashMap<E, Long> elemMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Set<E>> expiryMap = new ConcurrentHashMap();
    private final AtomicLong nextExpirationTime = new AtomicLong();
    private final int expirationInterval;

    public ExpiryQueue(int expirationInterval) {
        this.expirationInterval = expirationInterval;
        this.nextExpirationTime.set(this.roundToNextInterval(Time.currentElapsedTime()));
    }

    private long roundToNextInterval(long time2) {
        return (time2 / (long)this.expirationInterval + 1L) * (long)this.expirationInterval;
    }

    public Long remove(E elem) {
        Set<E> set2;
        Long expiryTime = this.elemMap.remove(elem);
        if (expiryTime != null && (set2 = this.expiryMap.get(expiryTime)) != null) {
            set2.remove(elem);
        }
        return expiryTime;
    }

    public Long update(E elem, int timeout) {
        Set<E> prevSet;
        Set<E> existingSet;
        Long prevExpiryTime = this.elemMap.get(elem);
        long now = Time.currentElapsedTime();
        Long newExpiryTime = this.roundToNextInterval(now + (long)timeout);
        if (newExpiryTime.equals(prevExpiryTime)) {
            return null;
        }
        Set<Object> set2 = this.expiryMap.get(newExpiryTime);
        if (set2 == null && (existingSet = this.expiryMap.putIfAbsent(newExpiryTime, set2 = Collections.newSetFromMap(new ConcurrentHashMap()))) != null) {
            set2 = existingSet;
        }
        set2.add(elem);
        prevExpiryTime = this.elemMap.put(elem, newExpiryTime);
        if (prevExpiryTime != null && !newExpiryTime.equals(prevExpiryTime) && (prevSet = this.expiryMap.get(prevExpiryTime)) != null) {
            prevSet.remove(elem);
        }
        return newExpiryTime;
    }

    public long getWaitTime() {
        long expirationTime;
        long now = Time.currentElapsedTime();
        return now < (expirationTime = this.nextExpirationTime.get()) ? expirationTime - now : 0L;
    }

    public Set<E> poll() {
        long expirationTime;
        long now = Time.currentElapsedTime();
        if (now < (expirationTime = this.nextExpirationTime.get())) {
            return Collections.emptySet();
        }
        Set<E> set2 = null;
        long newExpirationTime = expirationTime + (long)this.expirationInterval;
        if (this.nextExpirationTime.compareAndSet(expirationTime, newExpirationTime)) {
            set2 = this.expiryMap.remove(expirationTime);
        }
        if (set2 == null) {
            return Collections.emptySet();
        }
        return set2;
    }

    public void dump(PrintWriter pwriter) {
        pwriter.print("Sets (");
        pwriter.print(this.expiryMap.size());
        pwriter.print(")/(");
        pwriter.print(this.elemMap.size());
        pwriter.println("):");
        ArrayList keys2 = new ArrayList(this.expiryMap.keySet());
        Collections.sort(keys2);
        Iterator iterator = keys2.iterator();
        while (iterator.hasNext()) {
            long time2 = (Long)iterator.next();
            Set<E> set2 = this.expiryMap.get(time2);
            if (set2 == null) continue;
            pwriter.print(set2.size());
            pwriter.print(" expire at ");
            pwriter.print(Time.elapsedTimeToDate(time2));
            pwriter.println(":");
            for (E elem : set2) {
                pwriter.print("\t");
                pwriter.println(elem.toString());
            }
        }
    }

    public Map<Long, Set<E>> getExpiryMap() {
        return Collections.unmodifiableMap(this.expiryMap);
    }
}

