/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server.admin;

import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import io.mantisrx.shaded.org.apache.zookeeper.server.admin.CommandOutputter;
import io.mantisrx.shaded.org.apache.zookeeper.server.admin.CommandResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonOutputter
implements CommandOutputter {
    static final Logger LOG = LoggerFactory.getLogger(JsonOutputter.class);
    public static final String ERROR_RESPONSE = "{\"error\": \"Exception writing command response to JSON\"}";
    private ObjectMapper mapper = new ObjectMapper();

    public JsonOutputter() {
        this.mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        this.mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        this.mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public void output(CommandResponse response, PrintWriter pw) {
        try {
            this.mapper.writeValue(pw, response.toMap());
        }
        catch (JsonGenerationException e2) {
            LOG.warn("Exception writing command response to JSON:", e2);
            pw.write(ERROR_RESPONSE);
        }
        catch (JsonMappingException e3) {
            LOG.warn("Exception writing command response to JSON:", e3);
            pw.write(ERROR_RESPONSE);
        }
        catch (IOException e4) {
            LOG.warn("Exception writing command response to JSON:", e4);
            pw.write(ERROR_RESPONSE);
        }
    }
}

